/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.common;

import com.android.java.model.JavaProject;
import com.android.java.model.builder.JavaLibraryPlugin;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleInitScripts {
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final ContentCreator myContentCreator;

    @NotNull
    public static GradleInitScripts getInstance() {
        return (GradleInitScripts)ServiceManager.getService(GradleInitScripts.class);
    }

    public GradleInitScripts(@NotNull EmbeddedDistributionPaths embeddedDistributionPaths) {
        this(embeddedDistributionPaths, new ContentCreator());
    }

    @VisibleForTesting
    GradleInitScripts(@NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull ContentCreator contentCreator) {
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myContentCreator = contentCreator;
    }

    public void addLocalMavenRepoInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        File initScriptFile = this.createLocalMavenRepoInitScriptFile();
        if (initScriptFile != null) {
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
    }

    @Nullable
    private File createLocalMavenRepoInitScriptFile() {
        List<File> repoPaths = this.myEmbeddedDistributionPaths.findAndroidStudioLocalMavenRepoPaths();
        String content = this.myContentCreator.createLocalMavenRepoInitScriptContent(repoPaths);
        if (content != null) {
            String fileName = "sync.local.repo";
            try {
                return GradleInitScripts.createInitScriptFile(fileName, content);
            }
            catch (Throwable e) {
                String message = String.format("Failed to set up Gradle init script: '%1$s'", fileName);
                GradleInitScripts.getLogger().warn(message, e);
            }
        }
        return null;
    }

    public void addApplyJavaLibraryPluginInitScriptCommandLineArg(@NotNull List<String> allArgs) {
        try {
            File initScriptFile = this.createApplyJavaLibraryPluginInitScriptFile();
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create init script that applies the Java library plugin", e);
        }
    }

    @NotNull
    private File createApplyJavaLibraryPluginInitScriptFile() throws IOException {
        String content = this.myContentCreator.createApplyJavaLibraryPluginInitScriptContent();
        return GradleInitScripts.createInitScriptFile("sync.java.lib", content);
    }

    @NotNull
    private static File createInitScriptFile(@NotNull String fileName, @NotNull String content) throws IOException {
        File file = FileUtil.createTempFile((String)fileName, (String)".gradle");
        file.deleteOnExit();
        FileUtil.writeToFile((File)file, (String)content);
        GradleInitScripts.getLogger().info(String.format("init script file %s contents %s", fileName, GradleInitScripts.escapeAsStringLiteral(content)));
        return file;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleInitScripts.class);
    }

    @NotNull
    private static String escapeAsStringLiteral(@NotNull String s) {
        Escaper escaper = Escapers.builder().addEscape('\b', "\\b").addEscape('\t', "\\t").addEscape('\n', "\\n").addEscape('\f', "\\f").addEscape('\r', "\\r").addEscape('\"', "\\\"").addEscape('\\', "\\\\").build();
        return "\"" + escaper.escape(s) + "\"";
    }

    private static void addInitScriptCommandLineArg(@NotNull File initScriptFile, @NotNull List<String> allArgs) {
        allArgs.add("--init-script");
        allArgs.add(initScriptFile.getAbsolutePath());
    }

    @VisibleForTesting
    static class JavaLibraryPluginJars {
        JavaLibraryPluginJars() {
        }

        @NotNull
        List<String> getJarPaths() {
            return Arrays.asList(PathManager.getJarPathForClass(JavaProject.class), PathManager.getJarPathForClass(JavaLibraryPlugin.class));
        }
    }

    @VisibleForTesting
    static class ContentCreator {
        @NotNull
        private final JavaLibraryPluginJars myJavaLibraryPluginJars;

        ContentCreator() {
            this(new JavaLibraryPluginJars());
        }

        ContentCreator(@NotNull JavaLibraryPluginJars javaLibraryPluginJars) {
            this.myJavaLibraryPluginJars = javaLibraryPluginJars;
        }

        @Nullable
        String createLocalMavenRepoInitScriptContent(@NotNull List<File> repoPaths) {
            if (repoPaths.isEmpty()) {
                return null;
            }
            String paths = "";
            for (File file : repoPaths) {
                String path = GradleImport.escapeGroovyStringLiteral(file.getPath());
                paths = paths + "      maven { url '" + path + "'}\n";
            }
            return "allprojects {\n  buildscript {\n    repositories {\n" + paths + "    }\n  }\n  repositories {\n" + paths + "  }\n}\n";
        }

        @NotNull
        String createApplyJavaLibraryPluginInitScriptContent() {
            List<String> paths = this.myJavaLibraryPluginJars.getJarPaths();
            StringBuilder classpath = new StringBuilder();
            classpath.append("classpath files([");
            int pathCount = paths.size();
            for (int i = 0; i < pathCount; ++i) {
                String jarPath = paths.get(i);
                classpath.append("'").append(jarPath).append("'");
                if (i >= pathCount - 1) continue;
                classpath.append(", ");
            }
            classpath.append("])");
            return "initscript {\n    dependencies {\n        " + classpath.toString() + "\n    }\n}\nallprojects {\n    apply plugin: " + JavaLibraryPlugin.class.getName() + "\n}\n";
        }
    }
}

