/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.facet.java;

import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetType;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.util.BuildMode;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFacet
extends Facet<JavaFacetConfiguration> {
    @NotNull
    private static FacetTypeId<JavaFacet> TYPE_ID = new FacetTypeId("java-gradle");
    @NonNls
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    @NonNls
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    private JavaModuleModel myJavaModuleModel;

    @Nullable
    public static JavaFacet getInstance(@NotNull Module module) {
        return (JavaFacet)FacetManager.getInstance((Module)module).getFacetByType(TYPE_ID);
    }

    public JavaFacet(@NotNull Module module, @NotNull String name, @NotNull JavaFacetConfiguration configuration) {
        super((FacetType)JavaFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
    }

    @NotNull
    public static JavaFacetType getFacetType() {
        FacetType facetType = FacetTypeRegistry.getInstance().findFacetType("java-gradle");
        assert (facetType instanceof JavaFacetType);
        return (JavaFacetType)facetType;
    }

    @NotNull
    public static FacetTypeId<JavaFacet> getFacetTypeId() {
        return TYPE_ID;
    }

    @NotNull
    public static String getFacetId() {
        return "java-gradle";
    }

    @NotNull
    public static String getFacetName() {
        return "Java-Gradle";
    }

    public void initFacet() {
        MessageBusConnection connection = this.getModule().getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!JavaFacet.this.isDisposed()) {
                        PsiDocumentManager.getInstance((Project)JavaFacet.this.getModule().getProject()).commitAllDocuments();
                        JavaFacet.this.updateConfiguration();
                    }
                });
            }
        });
        this.updateConfiguration();
    }

    private void updateConfiguration() {
        JavaFacetConfiguration config = (JavaFacetConfiguration)this.getConfiguration();
        try {
            FacetUtil.saveFacetConfiguration((FacetConfiguration)config);
        }
        catch (WriteExternalException e) {
            JavaFacet.getLog().error("Unable to save contents of 'Java-Gradle' facet", (Throwable)e);
        }
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(JavaFacet.class);
    }

    @Nullable
    public String getGradleTaskName(@NotNull BuildMode buildMode) {
        if (!((JavaFacetConfiguration)this.getConfiguration()).BUILDABLE) {
            return null;
        }
        switch (buildMode) {
            case ASSEMBLE: {
                return "assemble";
            }
            case COMPILE_JAVA: {
                return COMPILE_JAVA_TASK_NAME;
            }
        }
        return null;
    }

    public void setJavaModuleModel(@NotNull JavaModuleModel javaModuleModel) {
        this.myJavaModuleModel = javaModuleModel;
    }

    @Nullable
    public JavaModuleModel getJavaModuleModel() {
        return this.myJavaModuleModel;
    }
}

