/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.importing.NewProjectImportGradleSyncListener;
import com.android.tools.idea.gradle.project.importing.NewProjectSetup;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleProjectImporter {
    @NotNull
    private final SdkSync mySdkSync;
    @NotNull
    private final GradleSyncInvoker myGradleSyncInvoker;
    @NotNull
    private final NewProjectSetup myNewProjectSetup;
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;
    public static boolean ourSkipSetupFromTest;

    @NotNull
    public static GradleProjectImporter getInstance() {
        return (GradleProjectImporter)ServiceManager.getService(GradleProjectImporter.class);
    }

    public GradleProjectImporter(@NotNull SdkSync sdkSync, @NotNull GradleSyncInvoker gradleSyncInvoker) {
        this(sdkSync, gradleSyncInvoker, new NewProjectSetup(), new ProjectFolder.Factory());
    }

    @VisibleForTesting
    GradleProjectImporter(@NotNull SdkSync sdkSync, @NotNull GradleSyncInvoker gradleSyncInvoker, @NotNull NewProjectSetup newProjectSetup, @NotNull ProjectFolder.Factory projectFolderFactory) {
        this.mySdkSync = sdkSync;
        this.myGradleSyncInvoker = gradleSyncInvoker;
        this.myNewProjectSetup = newProjectSetup;
        this.myProjectFolderFactory = projectFolderFactory;
    }

    public void openProject(@NotNull VirtualFile selectedFile) {
        this.openOrImportProject(selectedFile, true);
    }

    public void importProject(@NotNull VirtualFile selectedFile) {
        this.openOrImportProject(selectedFile, false);
    }

    private void openOrImportProject(@NotNull VirtualFile selectedFile, boolean open) {
        VirtualFile projectFolder = GradleProjectImporter.findProjectFolder(selectedFile);
        File projectFolderPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectFolder);
        try {
            this.setUpLocalProperties(projectFolderPath);
        }
        catch (IOException e) {
            return;
        }
        try {
            String projectName = projectFolder.getName();
            this.openOrImportProject(projectName, projectFolderPath, Request.EMPTY_REQUEST, GradleProjectImporter.createNewProjectListener(projectFolder), open);
        }
        catch (Throwable e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
            }
            Messages.showErrorDialog((String)e.getMessage(), (String)(open ? "Open Project" : "Project Import"));
            this.getLogger().error(e);
        }
    }

    @NotNull
    private static VirtualFile findProjectFolder(@NotNull VirtualFile selectedFile) {
        return selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
    }

    private void setUpLocalProperties(@NotNull File projectFolderPath) throws IOException {
        try {
            LocalProperties localProperties = new LocalProperties(projectFolderPath);
            if (IdeInfo.getInstance().isAndroidStudio()) {
                this.mySdkSync.syncIdeAndProjectAndroidSdks(localProperties);
            }
        }
        catch (IOException e) {
            this.getLogger().info("Failed to sync SDKs", (Throwable)e);
            Messages.showErrorDialog((String)e.getMessage(), (String)"Project Import");
            throw e;
        }
    }

    @NotNull
    private Logger getLogger() {
        return Logger.getInstance(this.getClass());
    }

    @NotNull
    private static NewProjectImportGradleSyncListener createNewProjectListener(final @NotNull VirtualFile projectFolder) {
        return new NewProjectImportGradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)project, () -> {
                    FileChooserUtil.setLastOpenedFile((Project)project, (VirtualFile)projectFolder);
                    ProjectUtil.focusProjectWindow((Project)project, (boolean)false);
                    ToolWindows.activateProjectView(project);
                });
            }
        };
    }

    public void importProject(@NotNull String projectName, @NotNull File projectFolderPath, @Nullable GradleSyncListener listener) throws IOException, ConfigurationException {
        this.importProject(projectName, projectFolderPath, Request.EMPTY_REQUEST, listener);
    }

    public void importProject(@NotNull String projectName, @NotNull File projectFolderPath, @NotNull Request request, @Nullable GradleSyncListener listener) throws IOException, ConfigurationException {
        this.openOrImportProject(projectName, projectFolderPath, request, listener, false);
    }

    private void openOrImportProject(@NotNull String projectName, @NotNull File projectFolderPath, @NotNull Request request, @Nullable GradleSyncListener listener, boolean open) throws IOException, ConfigurationException {
        ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectFolderPath);
        projectFolder.createTopLevelBuildFile();
        projectFolder.createIdeaProjectFolder();
        Project newProject = request.getProject();
        if (newProject == null) {
            newProject = open ? this.myNewProjectSetup.openProject(projectFolderPath.getPath()) : this.myNewProjectSetup.createProject(projectName, projectFolderPath.getPath());
            GradleSettings gradleSettings = GradleSettings.getInstance((Project)newProject);
            gradleSettings.setGradleVmOptions("");
        }
        GradleProjectInfo.getInstance(newProject).setNewOrImportedProject(true);
        this.myNewProjectSetup.prepareProjectForImport(newProject, request.getLanguageLevel());
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            newProject.save();
        }
        this.myGradleSyncInvoker.requestProjectSync(newProject, GradleProjectImporter.createSyncRequestSettings(request), listener);
    }

    @VisibleForTesting
    @NotNull
    static GradleSyncInvoker.Request createSyncRequestSettings(@NotNull Request importProjectSettings) {
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request();
        request.setGenerateSourcesOnSuccess(importProjectSettings.isGenerateSourcesOnSuccess()).setRunInBackground(false).setUseCachedGradleModels(false).setNewOrImportedProject().setTrigger(GradleSyncStats.Trigger.TRIGGER_PROJECT_LOADED);
        return request;
    }

    public static class Request {
        @NotNull
        private static final Request EMPTY_REQUEST = new Request();
        @Nullable
        private Project myProject;
        @Nullable
        private LanguageLevel myLanguageLevel;
        private boolean myGenerateSourcesOnSuccess = true;

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public Request setProject(@Nullable Project project) {
            this.myProject = project;
            return this;
        }

        @Nullable
        public LanguageLevel getLanguageLevel() {
            return this.myLanguageLevel;
        }

        @NotNull
        public Request setLanguageLevel(@Nullable LanguageLevel languageLevel) {
            this.myLanguageLevel = languageLevel;
            return this;
        }

        public boolean isGenerateSourcesOnSuccess() {
            return this.myGenerateSourcesOnSuccess;
        }

        @NotNull
        public Request setGenerateSourcesOnSuccess(boolean generateSourcesOnSuccess) {
            this.myGenerateSourcesOnSuccess = generateSourcesOnSuccess;
            return this;
        }
    }
}

