/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectSetup {
    public static final ProjectType ANDROID_PROJECT_TYPE = new ProjectType("Android");

    @NotNull
    public Project createProject(@NotNull String projectName, @NotNull String projectPath) throws ConfigurationException {
        ProjectManager projectManager = ProjectManager.getInstance();
        Project newProject = projectManager.createProject(projectName, projectPath);
        if (newProject == null) {
            throw new NullPointerException("Failed to create a new project");
        }
        return newProject;
    }

    @NotNull
    Project openProject(@NotNull String projectPath) throws IOException {
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        Project newProject = projectManager.loadProject(projectPath);
        if (newProject == null) {
            throw new NullPointerException("Failed to open project at '" + projectPath + "'");
        }
        return newProject;
    }

    void prepareProjectForImport(@NotNull Project project, @Nullable LanguageLevel languageLevel) {
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            LanguageLevelProjectExtension extension;
            if (languageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)project)) != null) {
                extension.setLanguageLevel(languageLevel);
            }
            File compilerOutputDirPath = new File(Projects.getBaseDirPath(project), FileUtil.join((String[])new String[]{"build", "classes"}));
            String compilerOutputDirUrl = FilePaths.pathToIdeaUrl(compilerOutputDirPath);
            CompilerProjectExtension compilerProjectExt = CompilerProjectExtension.getInstance((Project)project);
            assert (compilerProjectExt != null);
            compilerProjectExt.setCompilerOutputUrl(compilerOutputDirUrl);
            ProjectTypeService.setProjectType((Project)project, (ProjectType)ANDROID_PROJECT_TYPE);
        }), null, null);
    }
}

