/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectFolder {
    public abstract void createTopLevelBuildFile() throws IOException;

    public abstract void createIdeaProjectFolder() throws IOException;

    @VisibleForTesting
    static class ProjectFolderImpl
    extends ProjectFolder {
        @NotNull
        private final File myPath;

        ProjectFolderImpl(@NotNull File path) {
            this.myPath = path;
        }

        @Override
        public void createTopLevelBuildFile() throws IOException {
            File buildFile = GradleUtil.getGradleBuildFilePath(this.myPath);
            if (buildFile.isFile()) {
                return;
            }
            FileUtilRt.createIfNotExists((File)buildFile);
            String contents = "// Top-level build file where you can add configuration options common to all sub-projects/modules." + SystemProperties.getLineSeparator();
            FileUtil.writeToFile((File)buildFile, (String)contents);
        }

        @Override
        public void createIdeaProjectFolder() throws IOException {
            File ideaFolderPath = new File(this.myPath, ".idea");
            if (ideaFolderPath.isDirectory()) {
                File librariesFolderPath = new File(ideaFolderPath, "libraries");
                if (librariesFolderPath.exists() && !FileUtil.delete((File)librariesFolderPath)) {
                    this.getLogger().info(String.format("Failed to delete %1$s'", librariesFolderPath.getPath()));
                }
                return;
            }
            FileUtil.ensureExists((File)ideaFolderPath);
        }

        @NotNull
        private Logger getLogger() {
            return Logger.getInstance(this.getClass());
        }
    }

    public static class Factory {
        @NotNull
        public ProjectFolder create(@NotNull File projectFolderPath) {
            return new ProjectFolderImpl(projectFolderPath);
        }
    }
}

