/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class JavaModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final Collection<JavaModuleContentRoot> myContentRoots;
    @NotNull
    private final Collection<JavaModuleDependency> myJavaModuleDependencies;
    @NotNull
    private final Collection<JarLibraryDependency> myJarLibraryDependencies;
    @NotNull
    private final Map<String, Set<File>> myArtifactsByConfiguration;
    @NotNull
    private final List<String> myConfigurations;
    @Nullable
    private final ExtIdeaCompilerOutput myCompilerOutput;
    @Nullable
    private final File myBuildFolderPath;
    @Nullable
    private final String myLanguageLevel;
    private final boolean myBuildable;
    private final boolean myAndroidModuleWithoutVariants;

    public JavaModuleModel(@NotNull String moduleName, @NotNull Collection<JavaModuleContentRoot> contentRoots, @NotNull Collection<JavaModuleDependency> javaModuleDependencies, @NotNull Collection<JarLibraryDependency> jarLibraryDependencies, @NotNull Map<String, Set<File>> artifactsByConfiguration, @Nullable ExtIdeaCompilerOutput compilerOutput, @Nullable File buildFolderPath, @Nullable String languageLevel, boolean buildable, boolean androidModuleWithoutVariants) {
        this.myModuleName = moduleName;
        this.myContentRoots = contentRoots;
        this.myJavaModuleDependencies = javaModuleDependencies;
        this.myJarLibraryDependencies = jarLibraryDependencies;
        this.myArtifactsByConfiguration = artifactsByConfiguration;
        this.myCompilerOutput = compilerOutput;
        this.myBuildFolderPath = buildFolderPath;
        this.myLanguageLevel = languageLevel;
        this.myBuildable = buildable;
        this.myAndroidModuleWithoutVariants = androidModuleWithoutVariants;
        this.myConfigurations = new ArrayList<String>(this.myArtifactsByConfiguration.keySet());
        Collections.sort(this.myConfigurations);
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public Collection<JavaModuleContentRoot> getContentRoots() {
        return this.myContentRoots;
    }

    public boolean containsSourceFile(@NotNull File file) {
        for (JavaModuleContentRoot contentRoot : this.getContentRoots()) {
            if (contentRoot == null || !JavaModuleModel.containsFile(contentRoot, file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFile(@NotNull JavaModuleContentRoot contentRoot, @NotNull File file) {
        return JavaModuleModel.containsFile(contentRoot.getSourceDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getTestDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getResourceDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getGenSourceDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getGenTestDirPaths(), file) || JavaModuleModel.containsFile(contentRoot.getTestResourceDirPaths(), file);
    }

    private static boolean containsFile(@NotNull Collection<File> folderPaths, @NotNull File file) {
        for (File path : folderPaths) {
            if (!FileUtil.isAncestor((File)path, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Map<String, Set<File>> getArtifactsByConfiguration() {
        return this.myArtifactsByConfiguration;
    }

    @Nullable
    public ExtIdeaCompilerOutput getCompilerOutput() {
        return this.myCompilerOutput;
    }

    @Nullable
    public File getBuildFolderPath() {
        return this.myBuildFolderPath;
    }

    @NotNull
    public Collection<JavaModuleDependency> getJavaModuleDependencies() {
        return this.myJavaModuleDependencies;
    }

    @NotNull
    public Collection<JarLibraryDependency> getJarLibraryDependencies() {
        return this.myJarLibraryDependencies;
    }

    public boolean isBuildable() {
        return this.myBuildable;
    }

    public boolean isAndroidModuleWithoutVariants() {
        return this.myAndroidModuleWithoutVariants;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        if (this.myLanguageLevel != null) {
            return LanguageLevel.parse((String)this.myLanguageLevel);
        }
        return null;
    }

    @NotNull
    public List<String> getConfigurations() {
        return this.myConfigurations;
    }

    public static boolean isBuildable(@NotNull GradleProject gradleProject) {
        for (GradleTask task : gradleProject.getTasks()) {
            if (!"compileJava".equals(task.getName())) continue;
            return true;
        }
        return false;
    }
}

