/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeNativeAndroidProject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 2L;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private IdeNativeAndroidProject myAndroidProject;
    @Nullable
    private transient GradleVersion myModelVersion;
    @NotNull
    private Map<String, NdkVariant> myVariantsByName = new HashMap<String, NdkVariant>();
    @NotNull
    private Map<String, NativeToolchain> myToolchainsByName = new HashMap<String, NativeToolchain>();
    @NotNull
    private Map<String, NativeSettings> mySettingsByName = new HashMap<String, NativeSettings>();
    @NotNull
    private String mySelectedVariantName;

    @Nullable
    public static NdkModuleModel get(@NotNull Module module) {
        NdkFacet facet = NdkFacet.getInstance(module);
        return facet != null ? NdkModuleModel.get(facet) : null;
    }

    @Nullable
    public static NdkModuleModel get(@NotNull NdkFacet ndkFacet) {
        NdkModuleModel androidModel = ndkFacet.getNdkModuleModel();
        if (androidModel == null) {
            return null;
        }
        return androidModel;
    }

    public NdkModuleModel(@NotNull String moduleName, @NotNull File rootDirPath, @NotNull IdeNativeAndroidProject androidProject) {
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        this.parseAndSetModelVersion();
        this.populateVariantsByName();
        this.populateToolchainsByName();
        this.populateSettingsByName();
        this.initializeSelectedVariant();
    }

    private void populateVariantsByName() {
        for (NativeArtifact artifact : this.myAndroidProject.getArtifacts()) {
            String variantName = this.modelVersionIsAtLeast("2.0.0") ? artifact.getGroupName() : artifact.getName();
            NdkVariant variant = this.myVariantsByName.get(variantName);
            if (variant == null) {
                variant = new NdkVariant(variantName);
                this.myVariantsByName.put(variant.getName(), variant);
            }
            variant.addArtifact(artifact);
        }
        if (this.myVariantsByName.isEmpty()) {
            this.myVariantsByName.put("-----", new NdkVariant("-----"));
        }
    }

    private void populateToolchainsByName() {
        for (NativeToolchain toolchain : this.myAndroidProject.getToolChains()) {
            this.myToolchainsByName.put(toolchain.getName(), toolchain);
        }
    }

    private void populateSettingsByName() {
        for (NativeSettings settings : this.myAndroidProject.getSettings()) {
            this.mySettingsByName.put(settings.getName(), settings);
        }
    }

    private void initializeSelectedVariant() {
        Set<String> variantNames = this.myVariantsByName.keySet();
        assert (!variantNames.isEmpty());
        if (variantNames.size() == 1) {
            this.mySelectedVariantName = (String)Iterables.getOnlyElement(variantNames);
            return;
        }
        for (String variantName : variantNames) {
            if (!variantName.equals("debug")) continue;
            this.mySelectedVariantName = variantName;
            return;
        }
        ArrayList<String> sortedVariantNames = new ArrayList<String>(variantNames);
        Collections.sort(sortedVariantNames);
        assert (!sortedVariantNames.isEmpty());
        this.mySelectedVariantName = (String)sortedVariantNames.get(0);
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    public boolean modelVersionIsAtLeast(@NotNull String revision) {
        return this.myModelVersion != null && this.myModelVersion.compareIgnoringQualifiers(revision) >= 0;
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public File getRootDirPath() {
        return this.myRootDirPath;
    }

    @NotNull
    public IdeNativeAndroidProject getAndroidProject() {
        return this.myAndroidProject;
    }

    @NotNull
    public Collection<String> getVariantNames() {
        return this.myVariantsByName.keySet();
    }

    @NotNull
    public Collection<NdkVariant> getVariants() {
        return this.myVariantsByName.values();
    }

    @NotNull
    public NdkVariant getSelectedVariant() {
        NdkVariant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        return selected;
    }

    public void setSelectedVariantName(@NotNull String name) {
        Collection<String> variantNames = this.getVariantNames();
        if (variantNames.contains(name)) {
            this.mySelectedVariantName = name;
        } else {
            this.initializeSelectedVariant();
        }
    }

    @Nullable
    public NativeToolchain findToolchain(@NotNull String toolchainName) {
        return this.myToolchainsByName.get(toolchainName);
    }

    @Nullable
    public NativeSettings findSettings(@NotNull String settingsName) {
        return this.mySettingsByName.get(settingsName);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myAndroidProject);
        out.writeObject(this.mySelectedVariantName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myAndroidProject = (IdeNativeAndroidProject)in.readObject();
        this.mySelectedVariantName = (String)in.readObject();
        this.parseAndSetModelVersion();
        this.myVariantsByName = new HashMap<String, NdkVariant>();
        this.myToolchainsByName = new HashMap<String, NativeToolchain>();
        this.mySettingsByName = new HashMap<String, NativeSettings>();
        this.populateVariantsByName();
        this.populateToolchainsByName();
        this.populateSettingsByName();
    }

    public class NdkVariant {
        @NotNull
        private final String myVariantName;
        @NotNull
        private final Map<String, NativeArtifact> myArtifactsByName = new HashMap<String, NativeArtifact>();

        private NdkVariant(String variantName) {
            this.myVariantName = variantName;
        }

        private void addArtifact(@NotNull NativeArtifact artifact) {
            this.myArtifactsByName.put(artifact.getName(), artifact);
        }

        @NotNull
        public String getName() {
            return this.myVariantName;
        }

        @NotNull
        public Collection<NativeArtifact> getArtifacts() {
            return this.myArtifactsByName.values();
        }

        @NotNull
        public Collection<File> getSourceFolders() {
            LinkedHashSet<File> sourceFolders = new LinkedHashSet<File>();
            for (NativeArtifact artifact : this.getArtifacts()) {
                if (NdkModuleModel.this.modelVersionIsAtLeast("2.0.0")) {
                    for (File headerRoot : artifact.getExportedHeaders()) {
                        sourceFolders.add(headerRoot);
                    }
                }
                for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
                    sourceFolders.add(sourceFolder.getFolderPath());
                }
                for (NativeFile sourceFile : artifact.getSourceFiles()) {
                    File parentFile = sourceFile.getFilePath().getParentFile();
                    if (parentFile == null) continue;
                    sourceFolders.add(parentFile);
                }
            }
            return ImmutableList.copyOf(sourceFolders);
        }
    }
}

