/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.java.model.JavaLibrary;
import com.android.java.model.JavaProject;
import com.android.java.model.SourceSet;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.model.java.NewJarLibraryDependencyFactory;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaCompilerOutputImpl;

public class NewJavaModuleModelFactory {
    @NotNull
    private static final String MAIN_SOURCE_SET_NAME = "main";
    @NotNull
    private static final String TEST_SOURCE_SET_NAME = "test";
    @NotNull
    private static final String COMPILE_SCOPE = "COMPILE";
    @NotNull
    private static final String TEST_SCOPE = "TEST";
    @NotNull
    private final NewJarLibraryDependencyFactory myNewJarLibraryDependencyFactory;

    public NewJavaModuleModelFactory() {
        this(new NewJarLibraryDependencyFactory());
    }

    NewJavaModuleModelFactory(@NotNull NewJarLibraryDependencyFactory newJarLibraryDependencyFactory) {
        this.myNewJarLibraryDependencyFactory = newJarLibraryDependencyFactory;
    }

    @NotNull
    public JavaModuleModel create(@NotNull GradleProject gradleProject, @NotNull JavaProject javaProject, boolean androidModuleWithoutVariants) {
        Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> dependencies2 = this.getDependencies(javaProject);
        return new JavaModuleModel(javaProject.getName(), NewJavaModuleModelFactory.getContentRoots(javaProject, gradleProject), (Collection)dependencies2.first, (Collection)dependencies2.second, Collections.emptyMap(), NewJavaModuleModelFactory.getCompilerOutput(javaProject), gradleProject.getBuildDirectory(), javaProject.getJavaLanguageLevel(), !androidModuleWithoutVariants && JavaModuleModel.isBuildable(gradleProject), androidModuleWithoutVariants);
    }

    @NotNull
    private Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> getDependencies(@NotNull JavaProject javaProject) {
        ArrayList<JavaModuleDependency> javaModuleDependencies = new ArrayList<JavaModuleDependency>();
        ArrayList<JarLibraryDependency> jarLibraryDependencies = new ArrayList<JarLibraryDependency>();
        Map<String, SourceSet> sourceSetByName = javaProject.getSourceSets().stream().collect(Collectors.toMap(SourceSet::getName, SourceSet2 -> SourceSet2));
        if (sourceSetByName.containsKey(MAIN_SOURCE_SET_NAME) && sourceSetByName.containsKey(TEST_SOURCE_SET_NAME)) {
            Collection dependenciesForMain = sourceSetByName.get(MAIN_SOURCE_SET_NAME).getCompileClasspathDependencies();
            Collection dependenciesForTest = sourceSetByName.get(TEST_SOURCE_SET_NAME).getCompileClasspathDependencies();
            ImmutableSet dependenciesForMainInSet = ImmutableSet.copyOf((Collection)dependenciesForMain);
            for (JavaLibrary library : dependenciesForMain) {
                this.createDependency(library, COMPILE_SCOPE, javaModuleDependencies, jarLibraryDependencies);
            }
            for (JavaLibrary library : dependenciesForTest) {
                if (dependenciesForMainInSet.contains((Object)library)) continue;
                this.createDependency(library, TEST_SCOPE, javaModuleDependencies, jarLibraryDependencies);
            }
        }
        return Pair.create(javaModuleDependencies, jarLibraryDependencies);
    }

    private void createDependency(@NotNull JavaLibrary javaLibrary, @NotNull String scope, @NotNull Collection<JavaModuleDependency> javaModuleDependencies, @NotNull Collection<JarLibraryDependency> jarLibraryDependencies) {
        if (javaLibrary.getProject() != null) {
            javaModuleDependencies.add(new JavaModuleDependency(javaLibrary.getName(), scope, false));
        } else {
            JarLibraryDependency jarLibraryDependency = this.myNewJarLibraryDependencyFactory.create(javaLibrary, scope);
            if (jarLibraryDependency != null) {
                jarLibraryDependencies.add(jarLibraryDependency);
            }
        }
    }

    @NotNull
    private static ExtIdeaCompilerOutput getCompilerOutput(@NotNull JavaProject javaProject) {
        IdeaCompilerOutputImpl compilerOutput = new IdeaCompilerOutputImpl();
        Map<String, SourceSet> sourceSetByName = javaProject.getSourceSets().stream().collect(Collectors.toMap(SourceSet::getName, SourceSet2 -> SourceSet2));
        if (sourceSetByName.containsKey(MAIN_SOURCE_SET_NAME) && sourceSetByName.containsKey(TEST_SOURCE_SET_NAME)) {
            compilerOutput.setMainClassesDir(sourceSetByName.get(MAIN_SOURCE_SET_NAME).getClassesOutputDirectory());
            compilerOutput.setMainResourcesDir(sourceSetByName.get(MAIN_SOURCE_SET_NAME).getResourcesOutputDirectory());
            compilerOutput.setTestClassesDir(sourceSetByName.get(TEST_SOURCE_SET_NAME).getClassesOutputDirectory());
            compilerOutput.setTestResourcesDir(sourceSetByName.get(TEST_SOURCE_SET_NAME).getResourcesOutputDirectory());
        }
        return compilerOutput;
    }

    @NotNull
    private static Collection<JavaModuleContentRoot> getContentRoots(@NotNull JavaProject javaProject, @NotNull GradleProject gradleProject) {
        ArrayList<File> sourceDirPaths = new ArrayList<File>();
        ArrayList<File> resourceDirPaths = new ArrayList<File>();
        ArrayList<File> testDirPaths = new ArrayList<File>();
        ArrayList<File> testResourceDirPaths = new ArrayList<File>();
        for (SourceSet sourceSet : javaProject.getSourceSets()) {
            if (sourceSet.getName().equals(TEST_SOURCE_SET_NAME)) {
                testDirPaths.addAll(sourceSet.getSourceDirectories());
                testResourceDirPaths.addAll(sourceSet.getResourcesDirectories());
                continue;
            }
            sourceDirPaths.addAll(sourceSet.getSourceDirectories());
            resourceDirPaths.addAll(sourceSet.getResourcesDirectories());
        }
        ArrayList<File> excludeDirPaths = new ArrayList<File>();
        excludeDirPaths.add(gradleProject.getBuildDirectory());
        return Collections.singleton(new JavaModuleContentRoot(gradleProject.getProjectDirectory(), sourceDirPaths, Collections.emptyList(), resourceDirPaths, testDirPaths, Collections.emptyList(), testResourceDirPaths, excludeDirPaths));
    }
}

