/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.ClassField;
import com.android.builder.model.InstantRun;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.TestOptions;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifactOutput;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifactImpl;
import com.android.tools.idea.gradle.project.model.ide.android.IdeClassField;
import com.android.tools.idea.gradle.project.model.ide.android.IdeInstantRun;
import com.android.tools.idea.gradle.project.model.ide.android.IdeNativeLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.IdeTestOptions;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependenciesFactory;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeAndroidArtifactImpl
extends IdeBaseArtifactImpl
implements IdeAndroidArtifact {
    private static final long serialVersionUID = 3L;
    @NotNull
    private final Collection<AndroidArtifactOutput> myOutputs;
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final String mySourceGenTaskName;
    @NotNull
    private final Collection<File> myGeneratedResourceFolders;
    @NotNull
    private final Collection<File> myAdditionalRuntimeApks;
    @NotNull
    private final Map<String, ClassField> myBuildConfigFields;
    @NotNull
    private final Map<String, ClassField> myResValues;
    @Nullable
    private final IdeInstantRun myInstantRun;
    @Nullable
    private final String mySigningConfigName;
    @Nullable
    private final Set<String> myAbiFilters;
    @Nullable
    private final Collection<NativeLibrary> myNativeLibraries;
    @Nullable
    private final IdeTestOptions myTestOptions;
    private final boolean mySigned;
    private final int myHashCode;

    public IdeAndroidArtifactImpl(@NotNull AndroidArtifact artifact, @NotNull ModelCache modelCache, @NotNull IdeDependenciesFactory dependenciesFactory, @Nullable GradleVersion gradleVersion) {
        super((BaseArtifact)artifact, modelCache, dependenciesFactory, gradleVersion);
        this.myOutputs = IdeAndroidArtifactImpl.copyOutputs(artifact, modelCache);
        this.myApplicationId = artifact.getApplicationId();
        this.mySourceGenTaskName = artifact.getSourceGenTaskName();
        this.myGeneratedResourceFolders = ImmutableList.copyOf((Collection)artifact.getGeneratedResourceFolders());
        this.myBuildConfigFields = IdeAndroidArtifactImpl.copy(artifact.getBuildConfigFields(), modelCache, (V classField) -> new IdeClassField((ClassField)classField, modelCache));
        this.myResValues = IdeAndroidArtifactImpl.copy(artifact.getResValues(), modelCache, (V classField) -> new IdeClassField((ClassField)classField, modelCache));
        this.myInstantRun = IdeAndroidArtifactImpl.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getInstantRun(), instantRun -> new IdeInstantRun((InstantRun)instantRun, modelCache), null);
        this.mySigningConfigName = artifact.getSigningConfigName();
        this.myAbiFilters = IdeAndroidArtifactImpl.copy(artifact.getAbiFilters());
        this.myNativeLibraries = IdeAndroidArtifactImpl.copy(modelCache, artifact.getNativeLibraries());
        this.mySigned = artifact.isSigned();
        this.myAdditionalRuntimeApks = IdeAndroidArtifactImpl.copyNewProperty(() -> ((AndroidArtifact)artifact).getAdditionalRuntimeApks(), Collections.emptySet());
        this.myTestOptions = IdeAndroidArtifactImpl.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getTestOptions(), testOptions -> new IdeTestOptions((TestOptions)testOptions, modelCache), null);
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    private static Collection<AndroidArtifactOutput> copyOutputs(@NotNull AndroidArtifact artifact, @NotNull ModelCache modelCache) {
        try {
            Collection outputs = artifact.getOutputs();
            return IdeAndroidArtifactImpl.copy(outputs, modelCache, (K output) -> new IdeAndroidArtifactOutput((AndroidArtifactOutput)output, modelCache));
        }
        catch (RuntimeException e) {
            return Collections.emptyList();
        }
    }

    @Nullable
    private static Collection<NativeLibrary> copy(@NotNull ModelCache modelCache, @Nullable Collection<NativeLibrary> original) {
        return original != null ? IdeAndroidArtifactImpl.copy(original, modelCache, (K library) -> new IdeNativeLibrary((NativeLibrary)library, modelCache)) : null;
    }

    @NotNull
    public Collection<AndroidArtifactOutput> getOutputs() {
        return this.myOutputs;
    }

    @NotNull
    public String getApplicationId() {
        return this.myApplicationId;
    }

    @NotNull
    public String getSourceGenTaskName() {
        return this.mySourceGenTaskName;
    }

    @NotNull
    public Collection<File> getGeneratedResourceFolders() {
        return this.myGeneratedResourceFolders;
    }

    @NotNull
    public Map<String, ClassField> getBuildConfigFields() {
        return this.myBuildConfigFields;
    }

    @NotNull
    public Map<String, ClassField> getResValues() {
        return this.myResValues;
    }

    @NotNull
    public InstantRun getInstantRun() {
        if (this.myInstantRun != null) {
            return this.myInstantRun;
        }
        throw new UnsupportedMethodException("Unsupported method: AndroidArtifact.getInstantRun()");
    }

    public Collection<File> getAdditionalRuntimeApks() {
        return this.myAdditionalRuntimeApks;
    }

    @Nullable
    public TestOptions getTestOptions() {
        return this.myTestOptions;
    }

    @Nullable
    public String getSigningConfigName() {
        return this.mySigningConfigName;
    }

    @Nullable
    public Set<String> getAbiFilters() {
        return this.myAbiFilters;
    }

    @Nullable
    public Collection<NativeLibrary> getNativeLibraries() {
        return this.myNativeLibraries;
    }

    public boolean isSigned() {
        return this.mySigned;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidArtifactImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeAndroidArtifactImpl artifact = (IdeAndroidArtifactImpl)o;
        return artifact.canEquals(this) && this.mySigned == artifact.mySigned && Objects.equals(this.myOutputs, artifact.myOutputs) && Objects.equals(this.myApplicationId, artifact.myApplicationId) && Objects.equals(this.mySourceGenTaskName, artifact.mySourceGenTaskName) && Objects.equals(this.myGeneratedResourceFolders, artifact.myGeneratedResourceFolders) && Objects.equals(this.myBuildConfigFields, artifact.myBuildConfigFields) && Objects.equals(this.myResValues, artifact.myResValues) && Objects.equals(this.myInstantRun, artifact.myInstantRun) && Objects.equals(this.mySigningConfigName, artifact.mySigningConfigName) && Objects.equals(this.myAbiFilters, artifact.myAbiFilters) && Objects.equals(this.myAdditionalRuntimeApks, artifact.myAdditionalRuntimeApks) && Objects.equals(this.myNativeLibraries, artifact.myNativeLibraries) && Objects.equals(this.myTestOptions, artifact.myTestOptions);
    }

    @Override
    protected boolean canEquals(Object other) {
        return other instanceof IdeAndroidArtifactImpl;
    }

    @Override
    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myOutputs, this.myApplicationId, this.mySourceGenTaskName, this.myGeneratedResourceFolders, this.myBuildConfigFields, this.myResValues, this.myInstantRun, this.mySigningConfigName, this.myAbiFilters, this.myNativeLibraries, this.mySigned, this.myAdditionalRuntimeApks, this.myTestOptions);
    }

    @Override
    public String toString() {
        return "IdeAndroidArtifact{" + super.toString() + ", myOutputs=" + this.myOutputs + ", myApplicationId='" + this.myApplicationId + '\'' + ", mySourceGenTaskName='" + this.mySourceGenTaskName + '\'' + ", myGeneratedResourceFolders=" + this.myGeneratedResourceFolders + ", myBuildConfigFields=" + this.myBuildConfigFields + ", myResValues=" + this.myResValues + ", myInstantRun=" + this.myInstantRun + ", mySigningConfigName='" + this.mySigningConfigName + '\'' + ", myAbiFilters=" + this.myAbiFilters + ", myNativeLibraries=" + this.myNativeLibraries + ", mySigned=" + this.mySigned + ", myTestOptions=" + this.myTestOptions + "}";
    }
}

