/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.AndroidBundle;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.IdeLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeAndroidBundle
extends IdeLibrary
implements AndroidBundle {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final File myBundle;
    @NotNull
    private final File myFolder;
    @NotNull
    private final List<? extends AndroidLibrary> myLibraryDependencies;
    @NotNull
    private final Collection<? extends JavaLibrary> myJavaDependencies;
    @NotNull
    private final File myManifest;
    @NotNull
    private final File myJarFile;
    @NotNull
    private final File myResFolder;
    @NotNull
    private final File myAssetsFolder;
    @Nullable
    private final String myProjectVariant;
    private final int myHashCode;

    protected IdeAndroidBundle(@NotNull AndroidBundle bundle, @NotNull ModelCache modelCache) {
        super((Library)bundle, modelCache);
        this.myBundle = bundle.getBundle();
        this.myFolder = bundle.getFolder();
        this.myLibraryDependencies = IdeAndroidBundle.copy(bundle.getLibraryDependencies(), modelCache, (K library) -> new IdeAndroidLibrary((AndroidLibrary)library, modelCache));
        this.myJavaDependencies = IdeAndroidBundle.copyJavaDependencies(bundle, modelCache);
        this.myManifest = bundle.getManifest();
        this.myJarFile = bundle.getJarFile();
        this.myResFolder = bundle.getResFolder();
        this.myAssetsFolder = bundle.getAssetsFolder();
        this.myProjectVariant = bundle.getProjectVariant();
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    private static Collection<? extends JavaLibrary> copyJavaDependencies(@NotNull AndroidBundle bundle, @NotNull ModelCache modelCache) {
        Collection javaDependencies;
        try {
            javaDependencies = bundle.getJavaDependencies();
        }
        catch (UnsupportedMethodException ignored) {
            return Collections.emptyList();
        }
        return IdeAndroidBundle.copy(javaDependencies, modelCache, (K library) -> new IdeJavaLibrary((JavaLibrary)library, modelCache));
    }

    @NotNull
    public File getBundle() {
        return this.myBundle;
    }

    @NotNull
    public File getFolder() {
        return this.myFolder;
    }

    @NotNull
    public List<? extends AndroidLibrary> getLibraryDependencies() {
        return this.myLibraryDependencies;
    }

    @NotNull
    public Collection<? extends JavaLibrary> getJavaDependencies() {
        return this.myJavaDependencies;
    }

    @NotNull
    public File getManifest() {
        return this.myManifest;
    }

    @NotNull
    public File getJarFile() {
        return this.myJarFile;
    }

    @NotNull
    public File getResFolder() {
        return this.myResFolder;
    }

    @NotNull
    public File getAssetsFolder() {
        return this.myAssetsFolder;
    }

    @Nullable
    public String getProjectVariant() {
        return this.myProjectVariant;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidBundle)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeAndroidBundle bundle = (IdeAndroidBundle)o;
        return bundle.canEqual(this) && Objects.equals(this.myBundle, bundle.myBundle) && Objects.equals(this.myFolder, bundle.myFolder) && Objects.equals(this.myLibraryDependencies, bundle.myLibraryDependencies) && Objects.equals(this.myJavaDependencies, bundle.myJavaDependencies) && Objects.equals(this.myManifest, bundle.myManifest) && Objects.equals(this.myJarFile, bundle.myJarFile) && Objects.equals(this.myResFolder, bundle.myResFolder) && Objects.equals(this.myAssetsFolder, bundle.myAssetsFolder) && Objects.equals(this.myProjectVariant, bundle.myProjectVariant);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof IdeAndroidBundle;
    }

    @Override
    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myBundle, this.myFolder, this.myLibraryDependencies, this.myJavaDependencies, this.myManifest, this.myJarFile, this.myResFolder, this.myAssetsFolder, this.myProjectVariant);
    }

    @Override
    public String toString() {
        return super.toString() + "myBundle=" + this.myBundle + ", myFolder=" + this.myFolder + ", myLibraryDependencies=" + this.myLibraryDependencies + ", myJavaDependencies=" + this.myJavaDependencies + ", myManifest=" + this.myManifest + ", myJarFile=" + this.myJarFile + ", myResFolder=" + this.myResFolder + ", myAssetsFolder=" + this.myAssetsFolder + ", myProjectVariant='" + this.myProjectVariant + '\'';
    }
}

