/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.AndroidBundle;
import com.android.builder.model.AndroidLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidBundle;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.UnusedModelMethodException;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdeAndroidLibrary
extends IdeAndroidBundle
implements AndroidLibrary {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final Collection<File> myLocalJars;
    @NotNull
    private final File myProguardRules;
    @NotNull
    private final File myLintJar;
    @NotNull
    private final File myPublicResources;
    private final int myHashCode;

    public IdeAndroidLibrary(@NotNull AndroidLibrary library, @NotNull ModelCache modelCache) {
        super((AndroidBundle)library, modelCache);
        this.myLocalJars = ImmutableList.copyOf((Collection)library.getLocalJars());
        this.myProguardRules = library.getProguardRules();
        this.myLintJar = library.getLintJar();
        this.myPublicResources = library.getPublicResources();
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public Collection<File> getLocalJars() {
        return this.myLocalJars;
    }

    @NotNull
    public File getJniFolder() {
        throw new UnusedModelMethodException("getJniFolder");
    }

    @NotNull
    public File getAidlFolder() {
        throw new UnusedModelMethodException("getRenderscriptFolder");
    }

    @NotNull
    public File getRenderscriptFolder() {
        throw new UnusedModelMethodException("getRenderscriptFolder");
    }

    @NotNull
    public File getProguardRules() {
        return this.myProguardRules;
    }

    @NotNull
    public File getLintJar() {
        return this.myLintJar;
    }

    @NotNull
    public File getExternalAnnotations() {
        throw new UnusedModelMethodException("getExternalAnnotations");
    }

    @NotNull
    public File getPublicResources() {
        return this.myPublicResources;
    }

    @NotNull
    public File getSymbolFile() {
        throw new UnusedModelMethodException("getSymbolFile");
    }

    @Deprecated
    public boolean isOptional() {
        throw new UnusedModelMethodException("isOptional");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidLibrary)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeAndroidLibrary library = (IdeAndroidLibrary)o;
        return library.canEqual(this) && Objects.equals(this.myLocalJars, library.myLocalJars) && Objects.equals(this.myProguardRules, library.myProguardRules) && Objects.equals(this.myLintJar, library.myLintJar) && Objects.equals(this.myPublicResources, library.myPublicResources);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof IdeAndroidLibrary;
    }

    @Override
    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myLocalJars, this.myProguardRules, this.myLintJar, this.myPublicResources);
    }

    @Override
    public String toString() {
        return "IdeAndroidLibrary{" + super.toString() + ", myLocalJars=" + this.myLocalJars + ", myProguardRules=" + this.myProguardRules + ", myLintJar=" + this.myLintJar + ", myPublicResources=" + this.myPublicResources + "}";
    }
}

