/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ArtifactMetaData;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.LintOptions;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidProject;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBuildTypeContainer;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaCompileOptions;
import com.android.tools.idea.gradle.project.model.ide.android.IdeLintOptions;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeNativeToolchain;
import com.android.tools.idea.gradle.project.model.ide.android.IdeProductFlavorContainer;
import com.android.tools.idea.gradle.project.model.ide.android.IdeSigningConfig;
import com.android.tools.idea.gradle.project.model.ide.android.IdeSyncIssue;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariantImpl;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.UnusedModelMethodException;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependenciesFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeAndroidProjectImpl
extends IdeModel
implements IdeAndroidProject {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final String myModelVersion;
    @NotNull
    private final String myName;
    @NotNull
    private final ProductFlavorContainer myDefaultConfig;
    @NotNull
    private final Collection<BuildTypeContainer> myBuildTypes;
    @NotNull
    private final Collection<ProductFlavorContainer> myProductFlavors;
    @NotNull
    private final Collection<SyncIssue> mySyncIssues;
    @NotNull
    private final Collection<Variant> myVariants;
    @NotNull
    private final Collection<String> myFlavorDimensions;
    @NotNull
    private final String myCompileTarget;
    @NotNull
    private final Collection<String> myBootClassPath;
    @NotNull
    private final Collection<NativeToolchain> myNativeToolchains;
    @NotNull
    private final Collection<SigningConfig> mySigningConfigs;
    @NotNull
    private final LintOptions myLintOptions;
    @NotNull
    private final Collection<String> myUnresolvedDependencies;
    @NotNull
    private final JavaCompileOptions myJavaCompileOptions;
    @NotNull
    private final File myBuildFolder;
    @Nullable
    private final GradleVersion myParsedModelVersion;
    @Nullable
    private final String myBuildToolsVersion;
    @Nullable
    private final String myResourcePrefix;
    @Nullable
    private final Integer myPluginGeneration;
    private final int myApiVersion;
    private final boolean myLibrary;
    private final int myProjectType;
    private final boolean myBaseSplit;
    private final int myHashCode;

    public IdeAndroidProjectImpl(@NotNull AndroidProject project, @NotNull IdeDependenciesFactory dependenciesFactory) {
        this(project, new ModelCache(), dependenciesFactory);
    }

    @VisibleForTesting
    IdeAndroidProjectImpl(@NotNull AndroidProject project, @NotNull ModelCache modelCache, @NotNull IdeDependenciesFactory dependenciesFactory) {
        super(project, modelCache);
        this.myModelVersion = project.getModelVersion();
        this.myParsedModelVersion = GradleVersion.tryParse((String)this.myModelVersion);
        this.myName = project.getName();
        this.myDefaultConfig = modelCache.computeIfAbsent(project.getDefaultConfig(), container -> new IdeProductFlavorContainer((ProductFlavorContainer)container, modelCache));
        this.myBuildTypes = IdeAndroidProjectImpl.copy(project.getBuildTypes(), modelCache, (K container) -> new IdeBuildTypeContainer((BuildTypeContainer)container, modelCache));
        this.myProductFlavors = IdeAndroidProjectImpl.copy(project.getProductFlavors(), modelCache, (K container) -> new IdeProductFlavorContainer((ProductFlavorContainer)container, modelCache));
        this.myBuildToolsVersion = IdeAndroidProjectImpl.copyNewProperty(() -> ((AndroidProject)project).getBuildToolsVersion(), null);
        this.mySyncIssues = IdeAndroidProjectImpl.copy(project.getSyncIssues(), modelCache, (K issue2) -> new IdeSyncIssue((SyncIssue)issue2, modelCache));
        this.myVariants = IdeAndroidProjectImpl.copy(project.getVariants(), modelCache, (K variant) -> new IdeVariantImpl((Variant)variant, modelCache, dependenciesFactory, this.myParsedModelVersion));
        this.myFlavorDimensions = IdeAndroidProjectImpl.copyNewProperty(() -> ImmutableList.copyOf((Collection)project.getFlavorDimensions()), Collections.emptyList());
        this.myCompileTarget = project.getCompileTarget();
        this.myBootClassPath = ImmutableList.copyOf((Collection)project.getBootClasspath());
        this.myNativeToolchains = IdeAndroidProjectImpl.copy(project.getNativeToolchains(), modelCache, (K toolchain) -> new IdeNativeToolchain((NativeToolchain)toolchain, modelCache));
        this.mySigningConfigs = IdeAndroidProjectImpl.copy(project.getSigningConfigs(), modelCache, (K config) -> new IdeSigningConfig((SigningConfig)config, modelCache));
        this.myLintOptions = modelCache.computeIfAbsent(project.getLintOptions(), options -> new IdeLintOptions((LintOptions)options, modelCache, this.myParsedModelVersion));
        this.myUnresolvedDependencies = ImmutableSet.copyOf((Collection)project.getUnresolvedDependencies());
        this.myJavaCompileOptions = modelCache.computeIfAbsent(project.getJavaCompileOptions(), options -> new IdeJavaCompileOptions((JavaCompileOptions)options, modelCache));
        this.myBuildFolder = project.getBuildFolder();
        this.myResourcePrefix = project.getResourcePrefix();
        this.myApiVersion = project.getApiVersion();
        this.myLibrary = project.isLibrary();
        this.myProjectType = IdeAndroidProjectImpl.getProjectType(project, this.myParsedModelVersion);
        this.myPluginGeneration = IdeAndroidProjectImpl.copyNewProperty(() -> ((AndroidProject)project).getPluginGeneration(), null);
        this.myBaseSplit = IdeAndroidProjectImpl.copyNewProperty(() -> ((AndroidProject)project).isBaseSplit(), false);
        this.myHashCode = this.calculateHashCode();
    }

    private static int getProjectType(@NotNull AndroidProject project, @Nullable GradleVersion modelVersion) {
        if (modelVersion != null && modelVersion.isAtLeast(2, 3, 0)) {
            return project.getProjectType();
        }
        return project.isLibrary() ? 1 : 0;
    }

    @Override
    @Nullable
    public GradleVersion getParsedModelVersion() {
        return this.myParsedModelVersion;
    }

    @NotNull
    public String getModelVersion() {
        return this.myModelVersion;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public ProductFlavorContainer getDefaultConfig() {
        return this.myDefaultConfig;
    }

    @NotNull
    public Collection<BuildTypeContainer> getBuildTypes() {
        return this.myBuildTypes;
    }

    @NotNull
    public Collection<ProductFlavorContainer> getProductFlavors() {
        return this.myProductFlavors;
    }

    @NotNull
    public String getBuildToolsVersion() {
        if (this.myBuildToolsVersion != null) {
            return this.myBuildToolsVersion;
        }
        throw new UnsupportedMethodException("Unsupported method: AndroidProject.getBuildToolsVersion()");
    }

    @NotNull
    public Collection<SyncIssue> getSyncIssues() {
        return this.mySyncIssues;
    }

    @NotNull
    public Collection<Variant> getVariants() {
        return this.myVariants;
    }

    @NotNull
    public Collection<String> getFlavorDimensions() {
        return this.myFlavorDimensions;
    }

    @NotNull
    public Collection<ArtifactMetaData> getExtraArtifacts() {
        throw new UnusedModelMethodException("getExtraArtifacts");
    }

    @NotNull
    public String getCompileTarget() {
        return this.myCompileTarget;
    }

    @NotNull
    public Collection<String> getBootClasspath() {
        return this.myBootClassPath;
    }

    @NotNull
    public Collection<File> getFrameworkSources() {
        throw new UnusedModelMethodException("getFrameworkSources");
    }

    @NotNull
    public Collection<NativeToolchain> getNativeToolchains() {
        return this.myNativeToolchains;
    }

    @NotNull
    public AaptOptions getAaptOptions() {
        throw new UnusedModelMethodException("getAaptOptions");
    }

    @NotNull
    public Collection<SigningConfig> getSigningConfigs() {
        return this.mySigningConfigs;
    }

    @NotNull
    public LintOptions getLintOptions() {
        return this.myLintOptions;
    }

    @Deprecated
    @NotNull
    public Collection<String> getUnresolvedDependencies() {
        return this.myUnresolvedDependencies;
    }

    @NotNull
    public JavaCompileOptions getJavaCompileOptions() {
        return this.myJavaCompileOptions;
    }

    @NotNull
    public File getBuildFolder() {
        return this.myBuildFolder;
    }

    @Nullable
    public String getResourcePrefix() {
        return this.myResourcePrefix;
    }

    public int getApiVersion() {
        return this.myApiVersion;
    }

    @Deprecated
    public boolean isLibrary() {
        return this.myLibrary;
    }

    public int getProjectType() {
        return this.myProjectType;
    }

    public int getPluginGeneration() {
        if (this.myPluginGeneration != null) {
            return this.myPluginGeneration;
        }
        throw new UnsupportedMethodException("Unsupported method: AndroidProject.getPluginGeneration()");
    }

    public boolean isBaseSplit() {
        return this.myBaseSplit;
    }

    @Override
    public void forEachVariant(@NotNull Consumer<IdeVariant> action) {
        for (Variant variant : this.myVariants) {
            action.accept((IdeVariant)variant);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidProjectImpl)) {
            return false;
        }
        IdeAndroidProjectImpl project = (IdeAndroidProjectImpl)o;
        return this.myApiVersion == project.myApiVersion && this.myLibrary == project.myLibrary && this.myProjectType == project.myProjectType && this.myBaseSplit == project.myBaseSplit && Objects.equals(this.myPluginGeneration, project.myPluginGeneration) && Objects.equals(this.myModelVersion, project.myModelVersion) && Objects.equals(this.myParsedModelVersion, project.myParsedModelVersion) && Objects.equals(this.myName, project.myName) && Objects.equals(this.myDefaultConfig, project.myDefaultConfig) && Objects.equals(this.myBuildTypes, project.myBuildTypes) && Objects.equals(this.myProductFlavors, project.myProductFlavors) && Objects.equals(this.myBuildToolsVersion, project.myBuildToolsVersion) && Objects.equals(this.mySyncIssues, project.mySyncIssues) && Objects.equals(this.myVariants, project.myVariants) && Objects.equals(this.myFlavorDimensions, project.myFlavorDimensions) && Objects.equals(this.myCompileTarget, project.myCompileTarget) && Objects.equals(this.myBootClassPath, project.myBootClassPath) && Objects.equals(this.myNativeToolchains, project.myNativeToolchains) && Objects.equals(this.mySigningConfigs, project.mySigningConfigs) && Objects.equals(this.myLintOptions, project.myLintOptions) && Objects.equals(this.myUnresolvedDependencies, project.myUnresolvedDependencies) && Objects.equals(this.myJavaCompileOptions, project.myJavaCompileOptions) && Objects.equals(this.myBuildFolder, project.myBuildFolder) && Objects.equals(this.myResourcePrefix, project.myResourcePrefix);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myModelVersion, this.myParsedModelVersion, this.myName, this.myDefaultConfig, this.myBuildTypes, this.myProductFlavors, this.myBuildToolsVersion, this.mySyncIssues, this.myVariants, this.myFlavorDimensions, this.myCompileTarget, this.myBootClassPath, this.myNativeToolchains, this.mySigningConfigs, this.myLintOptions, this.myUnresolvedDependencies, this.myJavaCompileOptions, this.myBuildFolder, this.myResourcePrefix, this.myApiVersion, this.myLibrary, this.myProjectType, this.myPluginGeneration, this.myBaseSplit);
    }

    public String toString() {
        return "IdeAndroidProject{myModelVersion='" + this.myModelVersion + '\'' + ", myName='" + this.myName + '\'' + ", myDefaultConfig=" + this.myDefaultConfig + ", myBuildTypes=" + this.myBuildTypes + ", myProductFlavors=" + this.myProductFlavors + ", myBuildToolsVersion='" + this.myBuildToolsVersion + '\'' + ", mySyncIssues=" + this.mySyncIssues + ", myVariants=" + this.myVariants + ", myFlavorDimensions=" + this.myFlavorDimensions + ", myCompileTarget='" + this.myCompileTarget + '\'' + ", myBootClassPath=" + this.myBootClassPath + ", myNativeToolchains=" + this.myNativeToolchains + ", mySigningConfigs=" + this.mySigningConfigs + ", myLintOptions=" + this.myLintOptions + ", myUnresolvedDependencies=" + this.myUnresolvedDependencies + ", myJavaCompileOptions=" + this.myJavaCompileOptions + ", myBuildFolder=" + this.myBuildFolder + ", myResourcePrefix='" + this.myResourcePrefix + '\'' + ", myApiVersion=" + this.myApiVersion + ", myLibrary=" + this.myLibrary + ", myProjectType=" + this.myProjectType + ", myPluginGeneration=" + this.myPluginGeneration + ", myBaseSplit=" + this.myBaseSplit + "}";
    }
}

