/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.ApiVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeApiVersion
extends IdeModel
implements ApiVersion {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myApiString;
    @Nullable
    private final String myCodename;
    private final int myApiLevel;
    private final int myHashCode;

    public IdeApiVersion(@NotNull ApiVersion version, @NotNull ModelCache modelCache) {
        super(version, modelCache);
        this.myApiString = version.getApiString();
        this.myCodename = version.getCodename();
        this.myApiLevel = version.getApiLevel();
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getApiString() {
        return this.myApiString;
    }

    @Nullable
    public String getCodename() {
        return this.myCodename;
    }

    public int getApiLevel() {
        return this.myApiLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeApiVersion)) {
            return false;
        }
        IdeApiVersion version = (IdeApiVersion)o;
        return this.myApiLevel == version.myApiLevel && Objects.equals(this.myApiString, version.myApiString) && Objects.equals(this.myCodename, version.myCodename);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myApiString, this.myCodename, this.myApiLevel);
    }

    public String toString() {
        return "IdeApiVersion{myApiString='" + this.myApiString + '\'' + ", myCodename='" + this.myCodename + '\'' + ", myApiLevel=" + this.myApiLevel + '}';
    }
}

