/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeDependenciesImpl;
import com.android.tools.idea.gradle.project.model.ide.android.IdeDependencyGraphs;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeSourceProvider;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependencies;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependenciesFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeBaseArtifactImpl
extends IdeModel
implements IdeBaseArtifact {
    private static final String[] TEST_ARTIFACT_NAMES = new String[]{"_unit_test_", "_android_test_"};
    private static final long serialVersionUID = 4L;
    @NotNull
    private final String myName;
    @NotNull
    private final String myCompileTaskName;
    @NotNull
    private final String myAssembleTaskName;
    @NotNull
    private final File myClassesFolder;
    @NotNull
    private final com.android.tools.idea.gradle.project.model.ide.android.IdeDependencies myDependencies;
    @NotNull
    private final Set<String> myIdeSetupTaskNames;
    @NotNull
    private final Collection<File> myGeneratedSourceFolders;
    @NotNull
    private final Set<File> myAdditionalClassFolders;
    @NotNull
    private final IdeDependencies myLevel2Dependencies;
    @Nullable
    private final com.android.tools.idea.gradle.project.model.ide.android.IdeDependencies myCompileDependencies;
    @Nullable
    private final File myJavaResourcesFolder;
    @Nullable
    private final DependencyGraphs myDependencyGraphs;
    @Nullable
    private final IdeSourceProvider myVariantSourceProvider;
    @Nullable
    private final IdeSourceProvider myMultiFlavorSourceProvider;
    private final int myHashCode;

    protected IdeBaseArtifactImpl(@NotNull BaseArtifact artifact, @NotNull ModelCache modelCache, @NotNull IdeDependenciesFactory dependenciesFactory, @Nullable GradleVersion modelVersion) {
        super(artifact, modelCache);
        this.myName = artifact.getName();
        this.myCompileTaskName = artifact.getCompileTaskName();
        this.myAssembleTaskName = artifact.getAssembleTaskName();
        this.myClassesFolder = artifact.getClassesFolder();
        this.myJavaResourcesFolder = IdeBaseArtifactImpl.copyNewProperty(() -> ((BaseArtifact)artifact).getJavaResourcesFolder(), null);
        this.myDependencies = IdeBaseArtifactImpl.copy(artifact.getDependencies(), modelCache, modelVersion);
        this.myCompileDependencies = IdeBaseArtifactImpl.copyNewProperty(modelCache, () -> ((BaseArtifact)artifact).getCompileDependencies(), dependencies2 -> new IdeDependenciesImpl((Dependencies)dependencies2, modelCache, modelVersion), null);
        this.myDependencyGraphs = modelVersion != null && modelVersion.isAtLeast(2, 3, 0) ? (DependencyGraphs)modelCache.computeIfAbsent(artifact.getDependencyGraphs(), graphs -> new IdeDependencyGraphs((DependencyGraphs)graphs, modelCache)) : null;
        this.myIdeSetupTaskNames = ImmutableSet.copyOf(IdeBaseArtifactImpl.getIdeSetupTaskNames(artifact));
        this.myGeneratedSourceFolders = ImmutableList.copyOf(IdeBaseArtifactImpl.getGeneratedSourceFolders(artifact));
        this.myVariantSourceProvider = IdeBaseArtifactImpl.createSourceProvider(modelCache, artifact.getVariantSourceProvider());
        this.myMultiFlavorSourceProvider = IdeBaseArtifactImpl.createSourceProvider(modelCache, artifact.getMultiFlavorSourceProvider());
        this.myAdditionalClassFolders = IdeBaseArtifactImpl.copyNewProperty(() -> ((BaseArtifact)artifact).getAdditionalClassesFolders(), Collections.emptySet());
        this.myLevel2Dependencies = dependenciesFactory.create(artifact, modelVersion);
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    private static com.android.tools.idea.gradle.project.model.ide.android.IdeDependencies copy(@NotNull Dependencies original, @NotNull ModelCache modelCache, @Nullable GradleVersion modelVersion) {
        return modelCache.computeIfAbsent(original, dependencies2 -> new IdeDependenciesImpl((Dependencies)dependencies2, modelCache, modelVersion));
    }

    @NotNull
    private static Set<String> getIdeSetupTaskNames(@NotNull BaseArtifact artifact) {
        try {
            return ImmutableSet.copyOf((Collection)artifact.getIdeSetupTaskNames());
        }
        catch (NoSuchMethodError | UnsupportedMethodException e) {
            if (artifact instanceof AndroidArtifact) {
                return Collections.singleton(((AndroidArtifact)artifact).getSourceGenTaskName());
            }
            return Collections.emptySet();
        }
    }

    @NotNull
    private static Collection<File> getGeneratedSourceFolders(@NotNull BaseArtifact artifact) {
        try {
            List<File> folders = artifact.getGeneratedSourceFolders();
            return folders != null ? folders : Collections.emptyList();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            return Collections.emptyList();
        }
    }

    @Nullable
    private static IdeSourceProvider createSourceProvider(@NotNull ModelCache modelCache, @Nullable SourceProvider original) {
        return original != null ? modelCache.computeIfAbsent(original, provider -> new IdeSourceProvider((SourceProvider)provider, modelCache)) : null;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getCompileTaskName() {
        return this.myCompileTaskName;
    }

    @NotNull
    public String getAssembleTaskName() {
        return this.myAssembleTaskName;
    }

    @NotNull
    public File getClassesFolder() {
        return this.myClassesFolder;
    }

    @NotNull
    public File getJavaResourcesFolder() {
        if (this.myJavaResourcesFolder != null) {
            return this.myJavaResourcesFolder;
        }
        throw new UnsupportedMethodException("Unsupported method: BaseArtifact.getJavaResourcesFolder");
    }

    @Override
    @NotNull
    public com.android.tools.idea.gradle.project.model.ide.android.IdeDependencies getDependencies() {
        return this.myDependencies;
    }

    @NotNull
    public Dependencies getCompileDependencies() {
        if (this.myCompileDependencies != null) {
            return this.myCompileDependencies;
        }
        throw new UnsupportedMethodException("Unsupported method: BaseArtifact.getCompileDependencies()");
    }

    @NotNull
    public DependencyGraphs getDependencyGraphs() {
        if (this.myDependencyGraphs != null) {
            return this.myDependencyGraphs;
        }
        throw new UnsupportedMethodException("Unsupported method: BaseArtifact.getDependencyGraphs");
    }

    @NotNull
    public Set<String> getIdeSetupTaskNames() {
        return this.myIdeSetupTaskNames;
    }

    @Override
    @NotNull
    public IdeDependencies getLevel2Dependencies() {
        return this.myLevel2Dependencies;
    }

    @NotNull
    public Collection<File> getGeneratedSourceFolders() {
        return this.myGeneratedSourceFolders;
    }

    @Nullable
    public IdeSourceProvider getVariantSourceProvider() {
        return this.myVariantSourceProvider;
    }

    @Nullable
    public IdeSourceProvider getMultiFlavorSourceProvider() {
        return this.myMultiFlavorSourceProvider;
    }

    public Set<File> getAdditionalClassesFolders() {
        return this.myAdditionalClassFolders;
    }

    @Override
    public boolean isTestArtifact() {
        return ArrayUtil.contains((String)this.myName, (String[])TEST_ARTIFACT_NAMES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeBaseArtifactImpl)) {
            return false;
        }
        IdeBaseArtifactImpl artifact = (IdeBaseArtifactImpl)o;
        return artifact.canEquals(this) && Objects.equals(this.myName, artifact.myName) && Objects.equals(this.myCompileTaskName, artifact.myCompileTaskName) && Objects.equals(this.myAssembleTaskName, artifact.myAssembleTaskName) && Objects.equals(this.myClassesFolder, artifact.myClassesFolder) && Objects.equals(this.myAdditionalClassFolders, artifact.myAdditionalClassFolders) && Objects.equals(this.myJavaResourcesFolder, artifact.myJavaResourcesFolder) && Objects.equals(this.myDependencies, artifact.myDependencies) && Objects.equals(this.myLevel2Dependencies, artifact.myLevel2Dependencies) && Objects.equals(this.myCompileDependencies, artifact.myCompileDependencies) && Objects.equals(this.myDependencyGraphs, artifact.myDependencyGraphs) && Objects.equals(this.myIdeSetupTaskNames, artifact.myIdeSetupTaskNames) && Objects.equals(this.myGeneratedSourceFolders, artifact.myGeneratedSourceFolders) && Objects.equals(this.myVariantSourceProvider, artifact.myVariantSourceProvider) && Objects.equals(this.myMultiFlavorSourceProvider, artifact.myMultiFlavorSourceProvider);
    }

    protected boolean canEquals(Object other) {
        return other instanceof IdeBaseArtifactImpl;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myName, this.myCompileTaskName, this.myAssembleTaskName, this.myClassesFolder, this.myJavaResourcesFolder, this.myDependencies, this.myLevel2Dependencies, this.myCompileDependencies, this.myDependencyGraphs, this.myIdeSetupTaskNames, this.myGeneratedSourceFolders, this.myVariantSourceProvider, this.myMultiFlavorSourceProvider, this.myAdditionalClassFolders);
    }

    public String toString() {
        return "myName='" + this.myName + '\'' + ", myCompileTaskName='" + this.myCompileTaskName + '\'' + ", myAssembleTaskName='" + this.myAssembleTaskName + '\'' + ", myClassesFolder=" + this.myClassesFolder + ", myJavaResourcesFolder=" + this.myJavaResourcesFolder + ", myDependencies=" + this.myDependencies + ", myLevel2Dependencies" + this.myLevel2Dependencies + ", myCompileDependencies=" + this.myCompileDependencies + ", myDependencyGraphs=" + this.myDependencyGraphs + ", myIdeSetupTaskNames=" + this.myIdeSetupTaskNames + ", myGeneratedSourceFolders=" + this.myGeneratedSourceFolders + ", myVariantSourceProvider=" + this.myVariantSourceProvider + ", myMultiFlavorSourceProvider=" + this.myMultiFlavorSourceProvider;
    }
}

