/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.android.tools.idea.gradle.project.model.ide.android.IdeClassField;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.UnusedModelMethodException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeBaseConfig
extends IdeModel
implements BaseConfig {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myName;
    @NotNull
    private final Map<String, ClassField> myResValues;
    @NotNull
    private final Collection<File> myProguardFiles;
    @NotNull
    private final Collection<File> myConsumerProguardFiles;
    @NotNull
    private final Map<String, Object> myManifestPlaceholders;
    @Nullable
    private final String myApplicationIdSuffix;
    @Nullable
    private final String myVersionNameSuffix;
    @Nullable
    private final Boolean myMultiDexEnabled;
    private final int myHashCode;

    protected IdeBaseConfig(@NotNull BaseConfig config, @NotNull ModelCache modelCache) {
        super(config, modelCache);
        this.myName = config.getName();
        this.myResValues = IdeBaseConfig.copy(config.getResValues(), modelCache, (V classField) -> new IdeClassField((ClassField)classField, modelCache));
        this.myProguardFiles = ImmutableList.copyOf((Collection)config.getProguardFiles());
        this.myConsumerProguardFiles = ImmutableList.copyOf((Collection)config.getConsumerProguardFiles());
        this.myManifestPlaceholders = ImmutableMap.copyOf((Map)config.getManifestPlaceholders());
        this.myApplicationIdSuffix = config.getApplicationIdSuffix();
        this.myVersionNameSuffix = IdeBaseConfig.copyNewProperty(() -> ((BaseConfig)config).getVersionNameSuffix(), null);
        this.myMultiDexEnabled = IdeBaseConfig.copyNewProperty(() -> ((BaseConfig)config).getMultiDexEnabled(), null);
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public Map<String, ClassField> getBuildConfigFields() {
        throw new UnusedModelMethodException("getBuildConfigFields");
    }

    @NotNull
    public Map<String, ClassField> getResValues() {
        return this.myResValues;
    }

    @NotNull
    public Collection<File> getProguardFiles() {
        return this.myProguardFiles;
    }

    @NotNull
    public Collection<File> getConsumerProguardFiles() {
        return this.myConsumerProguardFiles;
    }

    @NotNull
    public Collection<File> getTestProguardFiles() {
        throw new UnusedModelMethodException("getTestProguardFiles");
    }

    @NotNull
    public Map<String, Object> getManifestPlaceholders() {
        return this.myManifestPlaceholders;
    }

    @NotNull
    public List<File> getJarJarRuleFiles() {
        throw new UnusedModelMethodException("getJarJarRuleFiles");
    }

    @Nullable
    public String getApplicationIdSuffix() {
        return this.myApplicationIdSuffix;
    }

    @Nullable
    public String getVersionNameSuffix() {
        return this.myVersionNameSuffix;
    }

    @Nullable
    public Boolean getMultiDexEnabled() {
        return this.myMultiDexEnabled;
    }

    @Nullable
    public File getMultiDexKeepFile() {
        throw new UnusedModelMethodException("getMultiDexKeepFile");
    }

    @Nullable
    public File getMultiDexKeepProguard() {
        throw new UnusedModelMethodException("getMultiDexKeepProguard");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeBaseConfig)) {
            return false;
        }
        IdeBaseConfig config = (IdeBaseConfig)o;
        return config.canEqual(this) && Objects.equals(this.myName, config.myName) && Objects.deepEquals(this.myResValues, config.myResValues) && Objects.deepEquals(this.myProguardFiles, config.myProguardFiles) && Objects.deepEquals(this.myConsumerProguardFiles, config.myConsumerProguardFiles) && Objects.deepEquals(this.myManifestPlaceholders, config.myManifestPlaceholders) && Objects.equals(this.myApplicationIdSuffix, config.myApplicationIdSuffix) && Objects.equals(this.myVersionNameSuffix, config.myVersionNameSuffix) && Objects.equals(this.myMultiDexEnabled, config.myMultiDexEnabled);
    }

    public boolean canEqual(Object other) {
        return other instanceof IdeBaseConfig;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myName, this.myResValues, this.myProguardFiles, this.myConsumerProguardFiles, this.myManifestPlaceholders, this.myApplicationIdSuffix, this.myVersionNameSuffix, this.myMultiDexEnabled);
    }

    public String toString() {
        return "myName='" + this.myName + '\'' + ", myResValues=" + this.myResValues + ", myProguardFiles=" + this.myProguardFiles + ", myConsumerProguardFiles=" + this.myConsumerProguardFiles + ", myManifestPlaceholders=" + this.myManifestPlaceholders + ", myApplicationIdSuffix='" + this.myApplicationIdSuffix + '\'' + ", myVersionNameSuffix='" + this.myVersionNameSuffix + '\'' + ", myMultiDexEnabled=" + this.myMultiDexEnabled;
    }
}

