/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBuildType;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeSourceProvider;
import com.android.tools.idea.gradle.project.model.ide.android.IdeSourceProviderContainer;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdeBuildTypeContainer
extends IdeModel
implements BuildTypeContainer {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final IdeBuildType myBuildType;
    @NotNull
    private final IdeSourceProvider mySourceProvider;
    @NotNull
    private final Collection<SourceProviderContainer> myExtraSourceProviders;
    private final int myHashCode;

    public IdeBuildTypeContainer(@NotNull BuildTypeContainer container, @NotNull ModelCache modelCache) {
        super(container, modelCache);
        this.myBuildType = modelCache.computeIfAbsent(container.getBuildType(), buildType -> new IdeBuildType((BuildType)buildType, modelCache));
        this.mySourceProvider = modelCache.computeIfAbsent(container.getSourceProvider(), provider -> new IdeSourceProvider((SourceProvider)provider, modelCache));
        this.myExtraSourceProviders = IdeBuildTypeContainer.copy(container.getExtraSourceProviders(), modelCache, (K sourceProviderContainer) -> new IdeSourceProviderContainer((SourceProviderContainer)sourceProviderContainer, modelCache));
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public IdeBuildType getBuildType() {
        return this.myBuildType;
    }

    @NotNull
    public IdeSourceProvider getSourceProvider() {
        return this.mySourceProvider;
    }

    @NotNull
    public Collection<SourceProviderContainer> getExtraSourceProviders() {
        return this.myExtraSourceProviders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeBuildTypeContainer)) {
            return false;
        }
        IdeBuildTypeContainer container = (IdeBuildTypeContainer)o;
        return Objects.equals(this.myBuildType, container.myBuildType) && Objects.equals(this.mySourceProvider, container.mySourceProvider) && Objects.equals(this.myExtraSourceProviders, container.myExtraSourceProviders);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myBuildType, this.mySourceProvider, this.myExtraSourceProviders);
    }

    public String toString() {
        return "IdeBuildTypeContainer{myBuildType=" + this.myBuildType + ", mySourceProvider=" + this.mySourceProvider + ", myExtraSourceProviders=" + this.myExtraSourceProviders + '}';
    }
}

