/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.IdeDependencies;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeDependenciesImpl
extends IdeModel
implements IdeDependencies {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final Collection<AndroidLibrary> myLibraries;
    @NotNull
    private final Collection<JavaLibrary> myJavaLibraries;
    @NotNull
    private final Collection<String> myProjects;
    private final int myHashCode;

    public IdeDependenciesImpl(@NotNull Dependencies dependencies2, @NotNull ModelCache modelCache, @Nullable GradleVersion modelVersion) {
        super(dependencies2, modelCache);
        this.myLibraries = IdeDependenciesImpl.copy(dependencies2.getLibraries(), modelCache, (K library) -> new IdeAndroidLibrary((AndroidLibrary)library, modelCache));
        this.myJavaLibraries = IdeDependenciesImpl.copy(dependencies2.getJavaLibraries(), modelCache, (K library) -> new IdeJavaLibrary((JavaLibrary)library, modelCache));
        this.myProjects = ImmutableList.copyOf((Collection)dependencies2.getProjects());
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public Collection<AndroidLibrary> getLibraries() {
        return this.myLibraries;
    }

    @NotNull
    public Collection<JavaLibrary> getJavaLibraries() {
        return this.myJavaLibraries;
    }

    @NotNull
    public Collection<String> getProjects() {
        return this.myProjects;
    }

    @Override
    public void forEachLibrary(@NotNull Consumer<IdeAndroidLibrary> action) {
        for (AndroidLibrary library : this.myLibraries) {
            action.accept((IdeAndroidLibrary)library);
        }
    }

    @Override
    public void forEachJavaLibrary(@NotNull Consumer<IdeJavaLibrary> action) {
        for (JavaLibrary library : this.myJavaLibraries) {
            action.accept((IdeJavaLibrary)library);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeDependenciesImpl)) {
            return false;
        }
        IdeDependenciesImpl that = (IdeDependenciesImpl)o;
        return Objects.equals(this.myLibraries, that.myLibraries) && Objects.equals(this.myJavaLibraries, that.myJavaLibraries) && Objects.equals(this.myProjects, that.myProjects);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myLibraries, this.myJavaLibraries, this.myProjects);
    }

    public String toString() {
        return "IdeDependencies{myLibraries=" + this.myLibraries + ", myJavaLibraries=" + this.myJavaLibraries + ", myProjects=" + this.myProjects + '}';
    }
}

