/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.build.FilterData;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdeFilterData
extends IdeModel
implements FilterData {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myIdentifier;
    @NotNull
    private final String myFilterType;
    private final int myHashCode;

    public IdeFilterData(@NotNull FilterData data, @NotNull ModelCache modelCache) {
        super(data, modelCache);
        this.myIdentifier = data.getIdentifier();
        this.myFilterType = data.getFilterType();
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getIdentifier() {
        return this.myIdentifier;
    }

    @NotNull
    public String getFilterType() {
        return this.myFilterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeFilterData)) {
            return false;
        }
        IdeFilterData data = (IdeFilterData)o;
        return Objects.equals(this.myIdentifier, data.myIdentifier) && Objects.equals(this.myFilterType, data.myFilterType);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myIdentifier, this.myFilterType);
    }

    public String toString() {
        return "IdeFilterData{myIdentifier='" + this.myIdentifier + '\'' + ", myFilterType='" + this.myFilterType + '\'' + "}";
    }
}

