/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.level2.GraphItem;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeGraphItem
extends IdeModel
implements GraphItem {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myArtifactAddress;
    @NotNull
    private final List<GraphItem> myDependencies;
    @Nullable
    private final String myRequestedCoordinates;
    private final int myHashCode;

    public IdeGraphItem(@NotNull GraphItem item, @NotNull ModelCache modelCache) {
        super(item, modelCache);
        this.myArtifactAddress = item.getArtifactAddress();
        this.myDependencies = IdeGraphItem.copy(item.getDependencies(), modelCache, (K item1) -> new IdeGraphItem((GraphItem)item1, modelCache));
        this.myRequestedCoordinates = item.getRequestedCoordinates();
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getArtifactAddress() {
        return this.myArtifactAddress;
    }

    @NotNull
    public List<GraphItem> getDependencies() {
        return this.myDependencies;
    }

    @Nullable
    public String getRequestedCoordinates() {
        return this.myRequestedCoordinates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeGraphItem)) {
            return false;
        }
        IdeGraphItem item = (IdeGraphItem)o;
        return Objects.equals(this.myArtifactAddress, item.myArtifactAddress) && Objects.equals(this.myDependencies, item.myDependencies) && Objects.equals(this.myRequestedCoordinates, item.myRequestedCoordinates);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myArtifactAddress, this.myDependencies, this.myRequestedCoordinates);
    }

    public String toString() {
        return "IdeGraphItem{myArtifactAddress='" + this.myArtifactAddress + '\'' + ", myDependencies=" + this.myDependencies + ", myRequestedCoordinates='" + this.myRequestedCoordinates + '\'' + '}';
    }
}

