/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.InstantRun;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdeInstantRun
extends IdeModel
implements InstantRun {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final File myInfoFile;
    private final boolean mySupportedByArtifact;
    private final int mySupportStatus;
    private final int myHashCode;

    public IdeInstantRun(@NotNull InstantRun run, @NotNull ModelCache modelCache) {
        super(run, modelCache);
        this.myInfoFile = run.getInfoFile();
        this.mySupportedByArtifact = run.isSupportedByArtifact();
        this.mySupportStatus = run.getSupportStatus();
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public File getInfoFile() {
        return this.myInfoFile;
    }

    public boolean isSupportedByArtifact() {
        return this.mySupportedByArtifact;
    }

    public int getSupportStatus() {
        return this.mySupportStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeInstantRun)) {
            return false;
        }
        IdeInstantRun run = (IdeInstantRun)o;
        return this.mySupportedByArtifact == run.mySupportedByArtifact && this.mySupportStatus == run.mySupportStatus && Objects.equals(this.myInfoFile, run.myInfoFile);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myInfoFile, this.mySupportedByArtifact, this.mySupportStatus);
    }

    public String toString() {
        return "IdeInstantRun{myInfoFile=" + this.myInfoFile + ", mySupportedByArtifact=" + this.mySupportedByArtifact + ", mySupportStatus=" + this.mySupportStatus + "}";
    }
}

