/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.JavaCompileOptions;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdeJavaCompileOptions
extends IdeModel
implements JavaCompileOptions {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myEncoding;
    @NotNull
    private final String mySourceCompatibility;
    @NotNull
    private final String myTargetCompatibility;
    private final int myHashCode;

    public IdeJavaCompileOptions(@NotNull JavaCompileOptions options, @NotNull ModelCache modelCache) {
        super(options, modelCache);
        this.myEncoding = options.getEncoding();
        this.mySourceCompatibility = options.getSourceCompatibility();
        this.myTargetCompatibility = options.getTargetCompatibility();
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getEncoding() {
        return this.myEncoding;
    }

    @NotNull
    public String getSourceCompatibility() {
        return this.mySourceCompatibility;
    }

    @NotNull
    public String getTargetCompatibility() {
        return this.myTargetCompatibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeJavaCompileOptions)) {
            return false;
        }
        IdeJavaCompileOptions options = (IdeJavaCompileOptions)o;
        return Objects.equals(this.myEncoding, options.myEncoding) && Objects.equals(this.mySourceCompatibility, options.mySourceCompatibility) && Objects.equals(this.myTargetCompatibility, options.myTargetCompatibility);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myEncoding, this.mySourceCompatibility, this.myTargetCompatibility);
    }

    public String toString() {
        return "IdeJavaCompileOptions{myEncoding='" + this.myEncoding + '\'' + ", mySourceCompatibility='" + this.mySourceCompatibility + '\'' + ", myTargetCompatibility='" + this.myTargetCompatibility + '\'' + "}";
    }
}

