/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.tools.idea.gradle.project.model.ide.android.IdeLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdeJavaLibrary
extends IdeLibrary
implements JavaLibrary {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final File myJarFile;
    @NotNull
    private final List<? extends JavaLibrary> myDependencies;
    private final int myHashCode;

    public IdeJavaLibrary(@NotNull JavaLibrary library, @NotNull ModelCache modelCache) {
        super((Library)library, modelCache);
        this.myJarFile = library.getJarFile();
        this.myDependencies = IdeJavaLibrary.copy(library.getDependencies(), modelCache, (K dependency) -> new IdeJavaLibrary((JavaLibrary)dependency, modelCache));
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public File getJarFile() {
        return this.myJarFile;
    }

    @NotNull
    public List<? extends JavaLibrary> getDependencies() {
        return this.myDependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeJavaLibrary)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeJavaLibrary library = (IdeJavaLibrary)o;
        return library.canEqual(this) && Objects.equals(this.myJarFile, library.myJarFile) && Objects.equals(this.myDependencies, library.myDependencies);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof IdeJavaLibrary;
    }

    @Override
    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myJarFile, this.myDependencies);
    }

    @Override
    public String toString() {
        return "IdeJavaLibrary{" + super.toString() + ", myJarFile=" + this.myJarFile + ", myDependencies=" + this.myDependencies + "}";
    }
}

