/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.idea.gradle.project.model.ide.android.IdeMavenCoordinates;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.level2.BuildFolderPaths;
import com.android.utils.FileUtils;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class IdeLibraries {
    private IdeLibraries() {
    }

    @NotNull
    public static String computeAddress(@NotNull Library library) {
        try {
            if (library.getProject() != null && library instanceof AndroidLibrary) {
                return library.getProject() + "::" + ((AndroidLibrary)library).getProjectVariant();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        IdeMavenCoordinates coordinate = IdeLibraries.computeResolvedCoordinate(library, new ModelCache());
        String artifactId = StringUtil.trimStart((String)coordinate.getArtifactId(), (String)":");
        artifactId = artifactId.replace(':', '.');
        String address = coordinate.getGroupId() + ":" + artifactId + ":" + coordinate.getVersion();
        String classifier = coordinate.getClassifier();
        if (classifier != null) {
            address = address + ":" + classifier;
        }
        String packaging = coordinate.getPackaging();
        address = address + "@" + packaging;
        return address.intern();
    }

    public static boolean isLocalAarModule(@NotNull AndroidLibrary androidLibrary, @NotNull BuildFolderPaths buildFolderPaths) {
        String projectPath = androidLibrary.getProject();
        if (projectPath == null) {
            return false;
        }
        File buildFolderPath = buildFolderPaths.findBuildFolderPath(projectPath);
        return buildFolderPath != null && !FileUtils.isFileInDirectory((File)androidLibrary.getBundle(), (File)buildFolderPath);
    }

    @NotNull
    public static IdeMavenCoordinates computeResolvedCoordinate(@NotNull Library library, @NotNull ModelCache modelCache) {
        if (library.getResolvedCoordinates() != null) {
            return modelCache.computeIfAbsent(library.getResolvedCoordinates(), coordinates -> new IdeMavenCoordinates((MavenCoordinates)coordinates, modelCache));
        }
        File jarFile = library instanceof JavaLibrary ? ((JavaLibrary)library).getJarFile() : ((AndroidLibrary)library).getBundle();
        return new IdeMavenCoordinates(jarFile, new ModelCache());
    }
}

