/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.Library;
import com.android.tools.idea.gradle.project.model.ide.android.IdeLibraries;
import com.android.tools.idea.gradle.project.model.ide.android.IdeMavenCoordinates;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.UnusedModelMethodException;
import java.util.Objects;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeLibrary
extends IdeModel
implements Library {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final IdeMavenCoordinates myResolvedCoordinates;
    @Nullable
    private final String myProject;
    @Nullable
    private final String myName;
    @Nullable
    private final Boolean myProvided;
    private final int myHashCode;

    protected IdeLibrary(@NotNull Library library, @NotNull ModelCache modelCache) {
        super(library, modelCache);
        this.myResolvedCoordinates = IdeLibraries.computeResolvedCoordinate(library, modelCache);
        this.myProject = IdeLibrary.copyNewProperty(() -> ((Library)library).getProject(), null);
        this.myName = IdeLibrary.copyNewProperty(() -> ((Library)library).getName(), null);
        this.myProvided = IdeLibrary.copyNewProperty(() -> ((Library)library).isProvided(), null);
        this.myHashCode = this.calculateHashCode();
    }

    @Nullable
    public IdeMavenCoordinates getRequestedCoordinates() {
        throw new UnusedModelMethodException("getRequestedCoordinates");
    }

    @NotNull
    public IdeMavenCoordinates getResolvedCoordinates() {
        return this.myResolvedCoordinates;
    }

    @Nullable
    public String getProject() {
        return this.myProject;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public boolean isSkipped() {
        throw new UnusedModelMethodException("isSkipped");
    }

    public boolean isProvided() {
        if (this.myProvided != null) {
            return this.myProvided;
        }
        throw new UnsupportedMethodException("Unsupported method: AndroidLibrary.isProvided()");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeLibrary)) {
            return false;
        }
        IdeLibrary library = (IdeLibrary)o;
        return library.canEqual(this) && Objects.equals(this.myProvided, library.myProvided) && Objects.equals(this.myResolvedCoordinates, library.myResolvedCoordinates) && Objects.equals(this.myProject, library.myProject) && Objects.equals(this.myName, library.myName);
    }

    public boolean canEqual(Object other) {
        return other instanceof IdeLibrary;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myResolvedCoordinates, this.myProject, this.myName, this.myProvided);
    }

    public String toString() {
        return "myResolvedCoordinates=" + this.myResolvedCoordinates + ", myProject='" + this.myProject + '\'' + ", myName='" + this.myName + '\'' + ", myProvided=" + this.myProvided;
    }
}

