/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Computable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeModel
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected IdeModel(@NotNull Object original, @NotNull ModelCache modelCache) {
        Object copy = modelCache.computeIfAbsent(original, recursiveModel1 -> this);
        if (copy != this) {
            throw new IllegalStateException("An existing copy was found in the cache");
        }
    }

    @Nullable
    protected static <K, V> V copyNewProperty(@NotNull ModelCache modelCache, @NotNull Computable<K> keyCreator, @NotNull Function<K, V> mapper, @Nullable V defaultValue) {
        try {
            Object key = keyCreator.compute();
            return key != null ? modelCache.computeIfAbsent(key, mapper) : defaultValue;
        }
        catch (UnsupportedMethodException ignored) {
            return defaultValue;
        }
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    protected static <T> T copyNewProperty(@NotNull Computable<T> propertyInvoker, @Nullable T defaultValue) {
        try {
            return (T)propertyInvoker.compute();
        }
        catch (UnsupportedMethodException ignored) {
            return defaultValue;
        }
    }

    @NotNull
    protected static <K, V> List<K> copy(@NotNull Collection<K> original, @NotNull ModelCache modelCache, @NotNull Function<K, V> mapper) {
        if (original.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder copies = ImmutableList.builder();
        for (K item : original) {
            V copy = modelCache.computeIfAbsent(item, mapper);
            copies.add(copy);
        }
        return copies.build();
    }

    @NotNull
    protected static <K, V> Map<K, V> copy(@NotNull Map<K, V> original, @NotNull ModelCache modelCache, @NotNull Function<V, V> mapper) {
        if (original.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder copies = ImmutableMap.builder();
        original.forEach((k, v) -> {
            Object copy = modelCache.computeIfAbsent(v, mapper);
            copies.put(k, copy);
        });
        return copies.build();
    }

    @Contract(value="!null -> !null")
    @Nullable
    protected static Set<String> copy(@Nullable Set<String> original) {
        return original != null ? ImmutableSet.copyOf(original) : null;
    }
}

