/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeNativeAndroidProject;
import com.android.tools.idea.gradle.project.model.ide.android.IdeNativeArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeNativeSettings;
import com.android.tools.idea.gradle.project.model.ide.android.IdeNativeToolchain;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeNativeAndroidProjectImpl
extends IdeModel
implements IdeNativeAndroidProject {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myModelVersion;
    @NotNull
    private final String myName;
    @NotNull
    private final List<File> myBuildFiles;
    @NotNull
    private final Collection<NativeArtifact> myArtifacts;
    @NotNull
    private final Collection<NativeToolchain> myToolChains;
    @NotNull
    private final Collection<NativeSettings> mySettings;
    @NotNull
    private final Map<String, String> myFileExtensions;
    @Nullable
    private final Collection<String> myBuildSystems;
    private final int myApiVersion;
    private final int myHashCode;

    public IdeNativeAndroidProjectImpl(@NotNull NativeAndroidProject project) {
        this(project, new ModelCache());
    }

    @VisibleForTesting
    IdeNativeAndroidProjectImpl(@NotNull NativeAndroidProject project, @NotNull ModelCache modelCache) {
        super(project, modelCache);
        this.myModelVersion = project.getModelVersion();
        this.myApiVersion = project.getApiVersion();
        this.myName = project.getName();
        this.myBuildFiles = ImmutableList.copyOf((Collection)project.getBuildFiles());
        this.myArtifacts = IdeNativeAndroidProjectImpl.copy(project.getArtifacts(), modelCache, (K artifact) -> new IdeNativeArtifact((NativeArtifact)artifact, modelCache));
        this.myToolChains = IdeNativeAndroidProjectImpl.copy(project.getToolChains(), modelCache, (K toolchain) -> new IdeNativeToolchain((NativeToolchain)toolchain, modelCache));
        this.mySettings = IdeNativeAndroidProjectImpl.copy(project.getSettings(), modelCache, (K settings) -> new IdeNativeSettings((NativeSettings)settings, modelCache));
        this.myFileExtensions = ImmutableMap.copyOf((Map)project.getFileExtensions());
        this.myBuildSystems = IdeNativeAndroidProjectImpl.copyBuildSystems(project);
        this.myHashCode = this.calculateHashCode();
    }

    @Nullable
    private static Collection<String> copyBuildSystems(@NotNull NativeAndroidProject project) {
        try {
            return ImmutableList.copyOf((Collection)project.getBuildSystems());
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @NotNull
    public String getModelVersion() {
        return this.myModelVersion;
    }

    public int getApiVersion() {
        return this.myApiVersion;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public Collection<File> getBuildFiles() {
        return this.myBuildFiles;
    }

    @NotNull
    public Collection<NativeArtifact> getArtifacts() {
        return this.myArtifacts;
    }

    @NotNull
    public Collection<NativeToolchain> getToolChains() {
        return this.myToolChains;
    }

    @NotNull
    public Collection<NativeSettings> getSettings() {
        return this.mySettings;
    }

    @NotNull
    public Map<String, String> getFileExtensions() {
        return this.myFileExtensions;
    }

    @NotNull
    public Collection<String> getBuildSystems() {
        if (this.myBuildSystems != null) {
            return this.myBuildSystems;
        }
        throw new UnsupportedMethodException("Unsupported method: NativeAndroidProject.getBuildSystems()");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeAndroidProjectImpl)) {
            return false;
        }
        IdeNativeAndroidProjectImpl project = (IdeNativeAndroidProjectImpl)o;
        return this.myApiVersion == project.myApiVersion && Objects.equals(this.myModelVersion, project.myModelVersion) && Objects.equals(this.myName, project.myName) && Objects.equals(this.myBuildFiles, project.myBuildFiles) && Objects.equals(this.myArtifacts, project.myArtifacts) && Objects.equals(this.myToolChains, project.myToolChains) && Objects.equals(this.mySettings, project.mySettings) && Objects.equals(this.myFileExtensions, project.myFileExtensions) && Objects.equals(this.myBuildSystems, project.myBuildSystems);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myModelVersion, this.myName, this.myBuildFiles, this.myArtifacts, this.myToolChains, this.mySettings, this.myFileExtensions, this.myBuildSystems, this.myApiVersion);
    }

    public String toString() {
        return "IdeNativeAndroidProject{myModelVersion='" + this.myModelVersion + '\'' + ", myName='" + this.myName + '\'' + ", myBuildFiles=" + this.myBuildFiles + ", myArtifacts=" + this.myArtifacts + ", myToolChains=" + this.myToolChains + ", mySettings=" + this.mySettings + ", myFileExtensions=" + this.myFileExtensions + ", myBuildSystems=" + this.myBuildSystems + ", myApiVersion=" + this.myApiVersion + "}";
    }

    public static class FactoryImpl
    implements IdeNativeAndroidProject.Factory {
        @Override
        @NotNull
        public IdeNativeAndroidProject create(@NotNull NativeAndroidProject project) {
            return new IdeNativeAndroidProjectImpl(project);
        }
    }
}

