/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeNativeFile;
import com.android.tools.idea.gradle.project.model.ide.android.IdeNativeFolder;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.UnusedModelMethodException;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeNativeArtifact
extends IdeModel
implements NativeArtifact {
    @NotNull
    private final String myName;
    @NotNull
    private final String myToolChain;
    @NotNull
    private final String myGroupName;
    @NotNull
    private final Collection<NativeFolder> mySourceFolders;
    @NotNull
    private final Collection<NativeFile> mySourceFiles;
    @NotNull
    private final Collection<File> myExportedHeaders;
    @NotNull
    private final File myOutputFile;
    @Nullable
    private final String myAbi;
    @Nullable
    private final String myTargetName;
    private final int myHashCode;

    public IdeNativeArtifact(@NotNull NativeArtifact artifact, @NotNull ModelCache modelCache) {
        super(artifact, modelCache);
        this.myName = artifact.getName();
        this.myToolChain = artifact.getToolChain();
        this.myGroupName = artifact.getGroupName();
        this.mySourceFolders = IdeNativeArtifact.copy(artifact.getSourceFolders(), modelCache, (K folder) -> new IdeNativeFolder((NativeFolder)folder, modelCache));
        this.mySourceFiles = IdeNativeArtifact.copy(artifact.getSourceFiles(), modelCache, (K file) -> new IdeNativeFile((NativeFile)file, modelCache));
        this.myExportedHeaders = ImmutableList.copyOf((Collection)artifact.getExportedHeaders());
        this.myAbi = IdeNativeArtifact.copyNewProperty(() -> ((NativeArtifact)artifact).getAbi(), null);
        this.myTargetName = IdeNativeArtifact.copyNewProperty(() -> ((NativeArtifact)artifact).getTargetName(), null);
        this.myOutputFile = artifact.getOutputFile();
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getToolChain() {
        return this.myToolChain;
    }

    @NotNull
    public String getGroupName() {
        return this.myGroupName;
    }

    @NotNull
    public String getAssembleTaskName() {
        throw new UnusedModelMethodException("getAssembleTaskName");
    }

    @NotNull
    public Collection<NativeFolder> getSourceFolders() {
        return this.mySourceFolders;
    }

    @NotNull
    public Collection<NativeFile> getSourceFiles() {
        return this.mySourceFiles;
    }

    @NotNull
    public Collection<File> getExportedHeaders() {
        return this.myExportedHeaders;
    }

    @NotNull
    public String getAbi() {
        if (this.myAbi != null) {
            return this.myAbi;
        }
        throw new UnsupportedMethodException("Unsupported method: NativeArtifact.getAbi()");
    }

    @NotNull
    public String getTargetName() {
        if (this.myTargetName != null) {
            return this.myTargetName;
        }
        throw new UnsupportedMethodException("Unsupported method: NativeArtifact.getTargetName()");
    }

    @NotNull
    public File getOutputFile() {
        return this.myOutputFile;
    }

    @NotNull
    public Collection<File> getRuntimeFiles() {
        throw new UnusedModelMethodException("getRuntimeFiles");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeArtifact)) {
            return false;
        }
        IdeNativeArtifact artifact = (IdeNativeArtifact)o;
        return Objects.equals(this.myName, artifact.myName) && Objects.equals(this.myToolChain, artifact.myToolChain) && Objects.equals(this.myGroupName, artifact.myGroupName) && Objects.equals(this.mySourceFolders, artifact.mySourceFolders) && Objects.equals(this.mySourceFiles, artifact.mySourceFiles) && Objects.equals(this.myExportedHeaders, artifact.myExportedHeaders) && Objects.equals(this.myAbi, artifact.myAbi) && Objects.equals(this.myTargetName, artifact.myTargetName) && Objects.equals(this.myOutputFile, artifact.myOutputFile);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myToolChain, this.myGroupName, this.mySourceFolders, this.mySourceFiles, this.myExportedHeaders, this.myAbi, this.myTargetName, this.myOutputFile);
    }

    public String toString() {
        return "IdeNativeArtifact{myName='" + this.myName + '\'' + ", myToolChain='" + this.myToolChain + '\'' + ", myGroupName='" + this.myGroupName + '\'' + ", mySourceFolders=" + this.mySourceFolders + ", mySourceFiles=" + this.mySourceFiles + ", myExportedHeaders=" + this.myExportedHeaders + ", myAbi='" + this.myAbi + '\'' + ", myTargetName='" + this.myTargetName + '\'' + ", myOutputFile=" + this.myOutputFile + "}";
    }
}

