/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.NativeFile;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdeNativeFile
extends IdeModel
implements NativeFile {
    private final File myFilePath;
    private final String mySettingsName;
    private final File myWorkingDirectory;
    private final int myHashCode;

    public IdeNativeFile(@NotNull NativeFile file, @NotNull ModelCache modelCache) {
        super(file, modelCache);
        this.myFilePath = file.getFilePath();
        this.mySettingsName = file.getSettingsName();
        this.myWorkingDirectory = file.getWorkingDirectory();
        this.myHashCode = this.calculateHashCode();
    }

    public File getFilePath() {
        return this.myFilePath;
    }

    public String getSettingsName() {
        return this.mySettingsName;
    }

    public File getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeFile)) {
            return false;
        }
        IdeNativeFile file = (IdeNativeFile)o;
        return Objects.equals(this.myFilePath, file.myFilePath) && Objects.equals(this.mySettingsName, file.mySettingsName) && Objects.equals(this.myWorkingDirectory, file.myWorkingDirectory);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myFilePath, this.mySettingsName, this.myWorkingDirectory);
    }

    public String toString() {
        return "IdeNativeFile{myFilePath=" + this.myFilePath + ", mySettingsName='" + this.mySettingsName + '\'' + ", myWorkingDirectory=" + this.myWorkingDirectory + "}";
    }
}

