/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.NativeLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdeNativeLibrary
extends IdeModel
implements NativeLibrary {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myName;
    @NotNull
    private final String myAbi;
    @NotNull
    private final String myToolchainName;
    @NotNull
    private final List<File> myCIncludeDirs;
    @NotNull
    private final List<File> myCppIncludeDirs;
    @NotNull
    private final List<File> myCSystemIncludeDirs;
    @NotNull
    private final List<File> myCppSystemIncludeDirs;
    @NotNull
    private final List<String> myCDefines;
    @NotNull
    private final List<String> myCppDefines;
    @NotNull
    private final List<String> myCCompilerFlags;
    @NotNull
    private final List<String> myCppCompilerFlags;
    @NotNull
    private final List<File> myDebuggableLibraryFolders;
    private final int myHashCode;

    public IdeNativeLibrary(@NotNull NativeLibrary library, @NotNull ModelCache modelCache) {
        super(library, modelCache);
        this.myName = library.getName();
        this.myAbi = library.getAbi();
        this.myToolchainName = library.getToolchainName();
        this.myCIncludeDirs = ImmutableList.copyOf((Collection)library.getCIncludeDirs());
        this.myCppIncludeDirs = ImmutableList.copyOf((Collection)library.getCppIncludeDirs());
        this.myCSystemIncludeDirs = ImmutableList.copyOf((Collection)library.getCSystemIncludeDirs());
        this.myCppSystemIncludeDirs = ImmutableList.copyOf((Collection)library.getCppSystemIncludeDirs());
        this.myCDefines = ImmutableList.copyOf((Collection)library.getCDefines());
        this.myCppDefines = ImmutableList.copyOf((Collection)library.getCppDefines());
        this.myCCompilerFlags = ImmutableList.copyOf((Collection)library.getCCompilerFlags());
        this.myCppCompilerFlags = ImmutableList.copyOf((Collection)library.getCppCompilerFlags());
        this.myDebuggableLibraryFolders = ImmutableList.copyOf((Collection)library.getDebuggableLibraryFolders());
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getAbi() {
        return this.myAbi;
    }

    @NotNull
    public String getToolchainName() {
        return this.myToolchainName;
    }

    @NotNull
    public List<File> getCIncludeDirs() {
        return this.myCIncludeDirs;
    }

    @NotNull
    public List<File> getCppIncludeDirs() {
        return this.myCppIncludeDirs;
    }

    @NotNull
    public List<File> getCSystemIncludeDirs() {
        return this.myCSystemIncludeDirs;
    }

    @NotNull
    public List<File> getCppSystemIncludeDirs() {
        return this.myCppSystemIncludeDirs;
    }

    @NotNull
    public List<String> getCDefines() {
        return this.myCDefines;
    }

    @NotNull
    public List<String> getCppDefines() {
        return this.myCppDefines;
    }

    @NotNull
    public List<String> getCCompilerFlags() {
        return this.myCCompilerFlags;
    }

    @NotNull
    public List<String> getCppCompilerFlags() {
        return this.myCppCompilerFlags;
    }

    @NotNull
    public List<File> getDebuggableLibraryFolders() {
        return this.myDebuggableLibraryFolders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeLibrary)) {
            return false;
        }
        IdeNativeLibrary library = (IdeNativeLibrary)o;
        return Objects.equals(this.myName, library.myName) && Objects.equals(this.myAbi, library.myAbi) && Objects.equals(this.myToolchainName, library.myToolchainName) && Objects.equals(this.myCIncludeDirs, library.myCIncludeDirs) && Objects.equals(this.myCppIncludeDirs, library.myCppIncludeDirs) && Objects.equals(this.myCSystemIncludeDirs, library.myCSystemIncludeDirs) && Objects.equals(this.myCppSystemIncludeDirs, library.myCppSystemIncludeDirs) && Objects.equals(this.myCDefines, library.myCDefines) && Objects.equals(this.myCppDefines, library.myCppDefines) && Objects.equals(this.myCCompilerFlags, library.myCCompilerFlags) && Objects.equals(this.myCppCompilerFlags, library.myCppCompilerFlags) && Objects.equals(this.myDebuggableLibraryFolders, library.myDebuggableLibraryFolders);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myAbi, this.myToolchainName, this.myCIncludeDirs, this.myCppIncludeDirs, this.myCSystemIncludeDirs, this.myCppSystemIncludeDirs, this.myCDefines, this.myCppDefines, this.myCCompilerFlags, this.myCppCompilerFlags, this.myDebuggableLibraryFolders);
    }

    public String toString() {
        return "IdeNativeLibrary{myName='" + this.myName + '\'' + ", myAbi='" + this.myAbi + '\'' + ", myToolchainName='" + this.myToolchainName + '\'' + ", myCIncludeDirs=" + this.myCIncludeDirs + ", myCppIncludeDirs=" + this.myCppIncludeDirs + ", myCSystemIncludeDirs=" + this.myCSystemIncludeDirs + ", myCppSystemIncludeDirs=" + this.myCppSystemIncludeDirs + ", myCDefines=" + this.myCDefines + ", myCppDefines=" + this.myCppDefines + ", myCCompilerFlags=" + this.myCCompilerFlags + ", myCppCompilerFlags=" + this.myCppCompilerFlags + ", myDebuggableLibraryFolders=" + this.myDebuggableLibraryFolders + "}";
    }
}

