/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.NativeToolchain;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeNativeToolchain
extends IdeModel
implements NativeToolchain {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myName;
    @Nullable
    private final File myCCompilerExecutable;
    @Nullable
    private final File myCppCompilerExecutable;
    private final int myHashCode;

    public IdeNativeToolchain(@NotNull NativeToolchain toolchain, @NotNull ModelCache modelCache) {
        super(toolchain, modelCache);
        this.myName = toolchain.getName();
        this.myCCompilerExecutable = toolchain.getCCompilerExecutable();
        this.myCppCompilerExecutable = toolchain.getCppCompilerExecutable();
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public File getCCompilerExecutable() {
        return this.myCCompilerExecutable;
    }

    @Nullable
    public File getCppCompilerExecutable() {
        return this.myCppCompilerExecutable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeNativeToolchain)) {
            return false;
        }
        IdeNativeToolchain toolchain = (IdeNativeToolchain)o;
        return Objects.equals(this.myName, toolchain.myName) && Objects.equals(this.myCCompilerExecutable, toolchain.myCCompilerExecutable) && Objects.equals(this.myCppCompilerExecutable, toolchain.myCppCompilerExecutable);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myCCompilerExecutable, this.myCppCompilerExecutable);
    }

    public String toString() {
        return "IdeNativeToolchain{myName='" + this.myName + '\'' + ", myCCompilerExecutable=" + this.myCCompilerExecutable + ", myCppCompilerExecutable=" + this.myCppCompilerExecutable + "}";
    }
}

