/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.tools.idea.gradle.project.model.ide.android.IdeFilterData;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeOutputFile
extends IdeModel
implements OutputFile {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myOutputType;
    @NotNull
    private final Collection<String> myFilterTypes;
    @NotNull
    private final Collection<FilterData> myFilters;
    @NotNull
    private final File myOutputFile;
    @NotNull
    private final Collection<? extends OutputFile> myOutputs;
    @Nullable
    private final OutputFile myMainOutputFile;
    @Nullable
    final Integer myVersionCode;
    private final int myHashCode;

    public IdeOutputFile(@NotNull OutputFile file, @NotNull ModelCache modelCache) {
        super(file, modelCache);
        this.myOutputType = file.getOutputType();
        this.myFilterTypes = ImmutableList.copyOf((Collection)file.getFilterTypes());
        this.myFilters = IdeOutputFile.copy(file.getFilters(), modelCache, (K data) -> new IdeFilterData((FilterData)data, modelCache));
        this.myOutputFile = file.getOutputFile();
        this.myMainOutputFile = IdeOutputFile.copyNewProperty(modelCache, () -> ((OutputFile)file).getMainOutputFile(), outputFile -> new IdeOutputFile((OutputFile)outputFile, modelCache), null);
        this.myOutputs = IdeOutputFile.copyOutputs(file, modelCache);
        this.myVersionCode = IdeOutputFile.copyNewProperty(() -> ((OutputFile)file).getVersionCode(), null);
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    private static Collection<? extends OutputFile> copyOutputs(@NotNull OutputFile file, @NotNull ModelCache modelCache) {
        try {
            Collection key = file.getOutputs();
            return IdeOutputFile.copy(key, modelCache, (K outputFile) -> new IdeOutputFile((OutputFile)outputFile, modelCache));
        }
        catch (UnsupportedMethodException ignored) {
            return Collections.emptyList();
        }
    }

    @NotNull
    public String getOutputType() {
        return this.myOutputType;
    }

    @NotNull
    public Collection<String> getFilterTypes() {
        return this.myFilterTypes;
    }

    @NotNull
    public Collection<FilterData> getFilters() {
        return this.myFilters;
    }

    @NotNull
    public File getOutputFile() {
        return this.myOutputFile;
    }

    @NotNull
    public OutputFile getMainOutputFile() {
        if (this.myMainOutputFile != null) {
            return this.myMainOutputFile;
        }
        throw new UnsupportedMethodException("getMainOutputFile()");
    }

    @NotNull
    public Collection<? extends OutputFile> getOutputs() {
        return this.myOutputs;
    }

    public int getVersionCode() {
        if (this.myVersionCode != null) {
            return this.myVersionCode;
        }
        throw new UnsupportedMethodException("getVersionCode");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeOutputFile)) {
            return false;
        }
        IdeOutputFile file = (IdeOutputFile)o;
        return Objects.equals(this.myVersionCode, file.myVersionCode) && Objects.equals(this.myOutputType, file.myOutputType) && Objects.equals(this.myFilterTypes, file.myFilterTypes) && Objects.equals(this.myFilters, file.myFilters) && Objects.equals(this.myOutputFile, file.myOutputFile) && Objects.equals(this.myOutputs, file.myOutputs) && this.mainOutputFileEquals(file);
    }

    private boolean mainOutputFileEquals(@NotNull IdeOutputFile file) {
        return this.myMainOutputFile == this ? file.myMainOutputFile == file : Objects.equals(this.myMainOutputFile, file.myMainOutputFile);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        int result = this.myOutputType.hashCode();
        result = 31 * result + this.myFilterTypes.hashCode();
        result = 31 * result + this.myFilters.hashCode();
        result = 31 * result + FileUtil.fileHashCode((File)this.myOutputFile);
        result = 31 * result + this.hashCode(this.myMainOutputFile);
        result = 31 * result + this.hashCode(this.myOutputs);
        result = 31 * result + Objects.hashCode(this.myVersionCode);
        return result;
    }

    private int hashCode(@NotNull Collection<? extends OutputFile> outputFiles) {
        int hashCode = 1;
        for (OutputFile outputFile : outputFiles) {
            hashCode = 31 * hashCode + this.hashCode(outputFile);
        }
        return hashCode;
    }

    private int hashCode(@Nullable OutputFile outputFile) {
        return outputFile != this ? Objects.hashCode(outputFile) : 1;
    }

    public String toString() {
        return "IdeOutputFile{myOutputType='" + this.myOutputType + '\'' + ", myFilterTypes=" + this.myFilterTypes + ", myFilters=" + this.myFilters + ", myOutputFile=" + this.myOutputFile + ", myMainOutputFile=" + this.toString(this.myMainOutputFile) + ", myOutputs=" + this.toString(this.myOutputs) + ", myVersionCode=" + this.myVersionCode + "}";
    }

    @NotNull
    private String toString(@NotNull Collection<? extends OutputFile> outputFiles) {
        int max = outputFiles.size() - 1;
        if (max == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        for (OutputFile outputFile : outputFiles) {
            b.append(this.toString(outputFile));
            if (i++ == max) {
                b.append(']');
                break;
            }
            b.append(", ");
        }
        return b.toString();
    }

    @NotNull
    private String toString(@Nullable OutputFile outputFile) {
        if (outputFile == this) {
            return "this";
        }
        return Objects.toString(outputFile);
    }
}

