/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.VectorDrawablesOptions;
import com.android.tools.idea.gradle.project.model.ide.android.IdeApiVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseConfig;
import com.android.tools.idea.gradle.project.model.ide.android.IdeSigningConfig;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVectorDrawablesOptions;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.UnusedModelMethodException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeProductFlavor
extends IdeBaseConfig
implements ProductFlavor {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final Map<String, String> myTestInstrumentationRunnerArguments;
    @NotNull
    private final Collection<String> myResourceConfigurations;
    @Nullable
    private final VectorDrawablesOptions myVectorDrawables;
    @Nullable
    private final String myDimension;
    @Nullable
    private final String myApplicationId;
    @Nullable
    private final Integer myVersionCode;
    @Nullable
    private final String myVersionName;
    @Nullable
    private final ApiVersion myMinSdkVersion;
    @Nullable
    private final ApiVersion myTargetSdkVersion;
    @Nullable
    private final Integer myMaxSdkVersion;
    @Nullable
    private final String myTestApplicationId;
    @Nullable
    private final String myTestInstrumentationRunner;
    @Nullable
    private final SigningConfig mySigningConfig;
    private final int myHashCode;

    public IdeProductFlavor(@NotNull ProductFlavor flavor, @NotNull ModelCache modelCache) {
        super((BaseConfig)flavor, modelCache);
        this.myTestInstrumentationRunnerArguments = ImmutableMap.copyOf((Map)flavor.getTestInstrumentationRunnerArguments());
        this.myResourceConfigurations = ImmutableList.copyOf((Collection)flavor.getResourceConfigurations());
        this.myVectorDrawables = IdeProductFlavor.copyVectorDrawables(flavor, modelCache);
        this.myDimension = flavor.getDimension();
        this.myApplicationId = flavor.getApplicationId();
        this.myVersionCode = flavor.getVersionCode();
        this.myVersionName = flavor.getVersionName();
        this.myMinSdkVersion = IdeProductFlavor.copy(modelCache, flavor.getMinSdkVersion());
        this.myTargetSdkVersion = IdeProductFlavor.copy(modelCache, flavor.getTargetSdkVersion());
        this.myMaxSdkVersion = flavor.getMaxSdkVersion();
        this.myTestApplicationId = flavor.getTestApplicationId();
        this.myTestInstrumentationRunner = flavor.getTestInstrumentationRunner();
        this.mySigningConfig = IdeProductFlavor.copy(modelCache, flavor.getSigningConfig());
        this.myHashCode = this.calculateHashCode();
    }

    @Nullable
    private static VectorDrawablesOptions copyVectorDrawables(@NotNull ProductFlavor flavor, @NotNull ModelCache modelCache) {
        VectorDrawablesOptions vectorDrawables;
        try {
            vectorDrawables = flavor.getVectorDrawables();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
        return modelCache.computeIfAbsent(vectorDrawables, options -> new IdeVectorDrawablesOptions((VectorDrawablesOptions)options, modelCache));
    }

    @Nullable
    private static IdeApiVersion copy(@NotNull ModelCache modelCache, @Nullable ApiVersion apiVersion) {
        if (apiVersion != null) {
            return modelCache.computeIfAbsent(apiVersion, version -> new IdeApiVersion((ApiVersion)version, modelCache));
        }
        return null;
    }

    @Nullable
    private static SigningConfig copy(@NotNull ModelCache modelCache, @Nullable SigningConfig signingConfig) {
        if (signingConfig != null) {
            return modelCache.computeIfAbsent(signingConfig, config -> new IdeSigningConfig((SigningConfig)config, modelCache));
        }
        return null;
    }

    @NotNull
    public Map<String, String> getTestInstrumentationRunnerArguments() {
        return this.myTestInstrumentationRunnerArguments;
    }

    @NotNull
    public Collection<String> getResourceConfigurations() {
        return this.myResourceConfigurations;
    }

    @NotNull
    public VectorDrawablesOptions getVectorDrawables() {
        if (this.myVectorDrawables != null) {
            return this.myVectorDrawables;
        }
        throw new UnsupportedMethodException("Unsupported method: ProductFlavor.getVectorDrawables");
    }

    @Nullable
    public String getDimension() {
        return this.myDimension;
    }

    @Nullable
    public String getApplicationId() {
        return this.myApplicationId;
    }

    @Nullable
    public Integer getVersionCode() {
        return this.myVersionCode;
    }

    @Nullable
    public String getVersionName() {
        return this.myVersionName;
    }

    @Nullable
    public ApiVersion getMinSdkVersion() {
        return this.myMinSdkVersion;
    }

    @Nullable
    public ApiVersion getTargetSdkVersion() {
        return this.myTargetSdkVersion;
    }

    @Nullable
    public Integer getMaxSdkVersion() {
        return this.myMaxSdkVersion;
    }

    @Nullable
    public Integer getRenderscriptTargetApi() {
        throw new UnusedModelMethodException("getRenderscriptTargetApi");
    }

    @Nullable
    public Boolean getRenderscriptSupportModeEnabled() {
        throw new UnusedModelMethodException("getRenderscriptSupportModeEnabled");
    }

    @Nullable
    public Boolean getRenderscriptSupportModeBlasEnabled() {
        throw new UnusedModelMethodException("getRenderscriptSupportModeBlasEnabled");
    }

    @Nullable
    public Boolean getRenderscriptNdkModeEnabled() {
        throw new UnusedModelMethodException("getRenderscriptNdkModeEnabled");
    }

    @Nullable
    public String getTestApplicationId() {
        return this.myTestApplicationId;
    }

    @Nullable
    public String getTestInstrumentationRunner() {
        return this.myTestInstrumentationRunner;
    }

    @Nullable
    public Boolean getTestHandleProfiling() {
        throw new UnusedModelMethodException("getTestHandleProfiling");
    }

    @Nullable
    public Boolean getTestFunctionalTest() {
        throw new UnusedModelMethodException("getTestFunctionalTest");
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        return this.mySigningConfig;
    }

    @Nullable
    public Boolean getWearAppUnbundled() {
        throw new UnusedModelMethodException("getWearAppUnbundled");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeProductFlavor)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeProductFlavor flavor = (IdeProductFlavor)o;
        return flavor.canEqual(this) && Objects.equals(this.myTestInstrumentationRunnerArguments, flavor.myTestInstrumentationRunnerArguments) && Objects.equals(this.myResourceConfigurations, flavor.myResourceConfigurations) && Objects.equals(this.myVectorDrawables, flavor.myVectorDrawables) && Objects.equals(this.myDimension, flavor.myDimension) && Objects.equals(this.myApplicationId, flavor.myApplicationId) && Objects.equals(this.myVersionCode, flavor.myVersionCode) && Objects.equals(this.myVersionName, flavor.myVersionName) && Objects.equals(this.myMinSdkVersion, flavor.myMinSdkVersion) && Objects.equals(this.myTargetSdkVersion, flavor.myTargetSdkVersion) && Objects.equals(this.myMaxSdkVersion, flavor.myMaxSdkVersion) && Objects.equals(this.myTestApplicationId, flavor.myTestApplicationId) && Objects.equals(this.myTestInstrumentationRunner, flavor.myTestInstrumentationRunner) && Objects.equals(this.mySigningConfig, flavor.mySigningConfig);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof IdeProductFlavor;
    }

    @Override
    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myTestInstrumentationRunnerArguments, this.myResourceConfigurations, this.myVectorDrawables, this.myDimension, this.myApplicationId, this.myVersionCode, this.myVersionName, this.myMinSdkVersion, this.myTargetSdkVersion, this.myMaxSdkVersion, this.myTestApplicationId, this.myTestInstrumentationRunner, this.mySigningConfig);
    }

    @Override
    public String toString() {
        return "IdeProductFlavor{" + super.toString() + ", myTestInstrumentationRunnerArguments=" + this.myTestInstrumentationRunnerArguments + ", myResourceConfigurations=" + this.myResourceConfigurations + ", myVectorDrawables=" + this.myVectorDrawables + ", myDimension='" + this.myDimension + '\'' + ", myApplicationId='" + this.myApplicationId + '\'' + ", myVersionCode=" + this.myVersionCode + ", myVersionName='" + this.myVersionName + '\'' + ", myMinSdkVersion=" + this.myMinSdkVersion + ", myTargetSdkVersion=" + this.myTargetSdkVersion + ", myMaxSdkVersion=" + this.myMaxSdkVersion + ", myTestApplicationId='" + this.myTestApplicationId + '\'' + ", myTestInstrumentationRunner='" + this.myTestInstrumentationRunner + '\'' + ", mySigningConfig=" + this.mySigningConfig + "}";
    }
}

