/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.SigningConfig;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.UnusedModelMethodException;
import java.io.File;
import java.util.Objects;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeSigningConfig
extends IdeModel
implements SigningConfig {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final String myName;
    @Nullable
    private final File myStoreFile;
    @Nullable
    private final String myStorePassword;
    @Nullable
    private final String myKeyAlias;
    @Nullable
    private final Boolean myV1SigningEnabled;
    private final int myHashCode;

    public IdeSigningConfig(@NotNull SigningConfig config, @NotNull ModelCache modelCache) {
        super(config, modelCache);
        this.myName = config.getName();
        this.myStoreFile = config.getStoreFile();
        this.myStorePassword = config.getStorePassword();
        this.myKeyAlias = config.getKeyAlias();
        this.myV1SigningEnabled = IdeSigningConfig.copyNewProperty(() -> ((SigningConfig)config).isV1SigningEnabled(), null);
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public File getStoreFile() {
        return this.myStoreFile;
    }

    @Nullable
    public String getStorePassword() {
        return this.myStorePassword;
    }

    @Nullable
    public String getKeyAlias() {
        return this.myKeyAlias;
    }

    @Nullable
    public String getKeyPassword() {
        throw new UnusedModelMethodException("getKeyPassword");
    }

    @Nullable
    public String getStoreType() {
        throw new UnusedModelMethodException("getStoreType");
    }

    public boolean isV1SigningEnabled() {
        if (this.myV1SigningEnabled != null) {
            return this.myV1SigningEnabled;
        }
        throw new UnsupportedMethodException("Unsupported method: SigningConfig.isV1SigningEnabled()");
    }

    public boolean isV2SigningEnabled() {
        throw new UnusedModelMethodException("isV2SigningEnabled");
    }

    public boolean isSigningReady() {
        throw new UnusedModelMethodException("isSigningReady");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeSigningConfig)) {
            return false;
        }
        IdeSigningConfig config = (IdeSigningConfig)o;
        return Objects.equals(this.myV1SigningEnabled, config.myV1SigningEnabled) && Objects.equals(this.myName, config.myName) && Objects.equals(this.myStoreFile, config.myStoreFile) && Objects.equals(this.myStorePassword, config.myStorePassword) && Objects.equals(this.myKeyAlias, config.myKeyAlias);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myStoreFile, this.myStorePassword, this.myKeyAlias, this.myV1SigningEnabled);
    }

    public String toString() {
        return "IdeSigningConfig{myName='" + this.myName + '\'' + ", myStoreFile=" + this.myStoreFile + ", myStorePassword='" + this.myStorePassword + '\'' + ", myKeyAlias='" + this.myKeyAlias + '\'' + ", myV1SigningEnabled=" + this.myV1SigningEnabled + '}';
    }
}

