/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdeSourceProvider
extends IdeModel
implements SourceProvider {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final String myName;
    @NotNull
    private final File myManifestFile;
    @NotNull
    private final Collection<File> myJavaDirectories;
    @NotNull
    private final Collection<File> myResourcesDirectories;
    @NotNull
    private final Collection<File> myAidlDirectories;
    @NotNull
    private final Collection<File> myRenderscriptDirectories;
    @NotNull
    private final Collection<File> myCDirectories;
    @NotNull
    private final Collection<File> myCppDirectories;
    @NotNull
    private final Collection<File> myResDirectories;
    @NotNull
    private final Collection<File> myAssetsDirectories;
    @NotNull
    private final Collection<File> myJniLibsDirectories;
    @NotNull
    private final Collection<File> myShadersDirectories;
    private final int myHashCode;

    public IdeSourceProvider(@NotNull SourceProvider provider, @NotNull ModelCache modelCache) {
        super(provider, modelCache);
        this.myName = provider.getName();
        this.myManifestFile = provider.getManifestFile();
        this.myJavaDirectories = ImmutableList.copyOf((Collection)provider.getJavaDirectories());
        this.myResourcesDirectories = ImmutableList.copyOf((Collection)provider.getResourcesDirectories());
        this.myAidlDirectories = ImmutableList.copyOf((Collection)provider.getAidlDirectories());
        this.myRenderscriptDirectories = ImmutableList.copyOf((Collection)provider.getRenderscriptDirectories());
        this.myCDirectories = ImmutableList.copyOf((Collection)provider.getCDirectories());
        this.myCppDirectories = ImmutableList.copyOf((Collection)provider.getCppDirectories());
        this.myResDirectories = ImmutableList.copyOf((Collection)provider.getResDirectories());
        this.myAssetsDirectories = ImmutableList.copyOf((Collection)provider.getAssetsDirectories());
        this.myJniLibsDirectories = ImmutableList.copyOf((Collection)provider.getJniLibsDirectories());
        this.myShadersDirectories = IdeSourceProvider.copyNewProperty(() -> ImmutableList.copyOf((Collection)provider.getShadersDirectories()), Collections.emptyList());
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public File getManifestFile() {
        return this.myManifestFile;
    }

    @NotNull
    public Collection<File> getJavaDirectories() {
        return this.myJavaDirectories;
    }

    @NotNull
    public Collection<File> getResourcesDirectories() {
        return this.myResourcesDirectories;
    }

    @NotNull
    public Collection<File> getAidlDirectories() {
        return this.myAidlDirectories;
    }

    @NotNull
    public Collection<File> getRenderscriptDirectories() {
        return this.myRenderscriptDirectories;
    }

    @NotNull
    public Collection<File> getCDirectories() {
        return this.myCDirectories;
    }

    @NotNull
    public Collection<File> getCppDirectories() {
        return this.myCppDirectories;
    }

    @NotNull
    public Collection<File> getResDirectories() {
        return this.myResDirectories;
    }

    @NotNull
    public Collection<File> getAssetsDirectories() {
        return this.myAssetsDirectories;
    }

    @NotNull
    public Collection<File> getJniLibsDirectories() {
        return this.myJniLibsDirectories;
    }

    @NotNull
    public Collection<File> getShadersDirectories() {
        return this.myShadersDirectories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeSourceProvider)) {
            return false;
        }
        IdeSourceProvider provider = (IdeSourceProvider)o;
        return Objects.equals(this.myName, provider.myName) && Objects.equals(this.myManifestFile, provider.myManifestFile) && Objects.equals(this.myJavaDirectories, provider.myJavaDirectories) && Objects.equals(this.myResourcesDirectories, provider.myResourcesDirectories) && Objects.equals(this.myAidlDirectories, provider.myAidlDirectories) && Objects.equals(this.myRenderscriptDirectories, provider.myRenderscriptDirectories) && Objects.equals(this.myCDirectories, provider.myCDirectories) && Objects.equals(this.myCppDirectories, provider.myCppDirectories) && Objects.equals(this.myResDirectories, provider.myResDirectories) && Objects.equals(this.myAssetsDirectories, provider.myAssetsDirectories) && Objects.equals(this.myJniLibsDirectories, provider.myJniLibsDirectories) && Objects.equals(this.myShadersDirectories, provider.myShadersDirectories);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myManifestFile, this.myJavaDirectories, this.myResourcesDirectories, this.myAidlDirectories, this.myRenderscriptDirectories, this.myCDirectories, this.myCppDirectories, this.myResDirectories, this.myAssetsDirectories, this.myJniLibsDirectories, this.myShadersDirectories);
    }

    public String toString() {
        return "IdeSourceProvider{myName='" + this.myName + '\'' + ", myManifestFile=" + this.myManifestFile + ", myJavaDirectories=" + this.myJavaDirectories + ", myResourcesDirectories=" + this.myResourcesDirectories + ", myAidlDirectories=" + this.myAidlDirectories + ", myRenderscriptDirectories=" + this.myRenderscriptDirectories + ", myCDirectories=" + this.myCDirectories + ", myCppDirectories=" + this.myCppDirectories + ", myResDirectories=" + this.myResDirectories + ", myAssetsDirectories=" + this.myAssetsDirectories + ", myJniLibsDirectories=" + this.myJniLibsDirectories + ", myShadersDirectories=" + this.myShadersDirectories + '}';
    }
}

