/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeSourceProvider;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdeSourceProviderContainer
extends IdeModel
implements SourceProviderContainer {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myArtifactName;
    @NotNull
    private final IdeSourceProvider mySourceProvider;
    private final int myHashCode;

    public IdeSourceProviderContainer(@NotNull SourceProviderContainer container, @NotNull ModelCache modelCache) {
        super(container, modelCache);
        this.myArtifactName = container.getArtifactName();
        this.mySourceProvider = modelCache.computeIfAbsent(container.getSourceProvider(), provider -> new IdeSourceProvider((SourceProvider)provider, modelCache));
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getArtifactName() {
        return this.myArtifactName;
    }

    @NotNull
    public IdeSourceProvider getSourceProvider() {
        return this.mySourceProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeSourceProviderContainer)) {
            return false;
        }
        IdeSourceProviderContainer container = (IdeSourceProviderContainer)o;
        return Objects.equals(this.myArtifactName, container.myArtifactName) && Objects.equals(this.mySourceProvider, container.mySourceProvider);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myArtifactName, this.mySourceProvider);
    }

    public String toString() {
        return "IdeSourceProviderContainer{myArtifactName='" + this.myArtifactName + '\'' + ", mySourceProvider=" + this.mySourceProvider + '}';
    }
}

