/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeSyncIssue
extends IdeModel
implements SyncIssue {
    private static final long serialVersionUID = 2L;
    @NotNull
    private final String myMessage;
    @Nullable
    private final String myData;
    @Nullable
    private final List<String> myMultiLineMessage;
    private final int mySeverity;
    private final int myType;
    private final int myHashCode;

    public IdeSyncIssue(@NotNull SyncIssue issue2, @NotNull ModelCache modelCache) {
        super(issue2, modelCache);
        this.myMessage = issue2.getMessage();
        this.myMultiLineMessage = IdeModel.copyNewProperty(() -> ((SyncIssue)issue2).getMultiLineMessage(), null);
        this.myData = issue2.getData();
        this.mySeverity = issue2.getSeverity();
        this.myType = issue2.getType();
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    public String getMessage() {
        return this.myMessage;
    }

    @Nullable
    public String getData() {
        return this.myData;
    }

    public int getSeverity() {
        return this.mySeverity;
    }

    public int getType() {
        return this.myType;
    }

    @Nullable
    public List<String> getMultiLineMessage() {
        return this.myMultiLineMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeSyncIssue)) {
            return false;
        }
        IdeSyncIssue issue2 = (IdeSyncIssue)o;
        return this.mySeverity == issue2.mySeverity && this.myType == issue2.myType && Objects.equals(this.myMessage, issue2.myMessage) && Objects.equals(this.myMultiLineMessage, issue2.myMultiLineMessage) && Objects.equals(this.myData, issue2.myData);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myMessage, this.myMultiLineMessage, this.myData, this.mySeverity, this.myType);
    }

    public String toString() {
        return "IdeSyncIssue{myMessage='" + this.myMessage + '\'' + ", myData='" + this.myData + '\'' + ", mySeverity=" + this.mySeverity + ", myType=" + this.myType + "}";
    }
}

