/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifactImpl;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeProductFlavor;
import com.android.tools.idea.gradle.project.model.ide.android.IdeTestedTargetVariant;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependenciesFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeVariantImpl
extends IdeModel
implements IdeVariant {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myName;
    @NotNull
    private final String myDisplayName;
    @NotNull
    private final IdeAndroidArtifact myMainArtifact;
    @NotNull
    private final Collection<AndroidArtifact> myExtraAndroidArtifacts;
    @NotNull
    private final Collection<JavaArtifact> myExtraJavaArtifacts;
    @NotNull
    private final String myBuildType;
    @NotNull
    private final List<String> myProductFlavors;
    @NotNull
    private final ProductFlavor myMergedFlavor;
    @NotNull
    private final Collection<TestedTargetVariant> myTestedTargetVariants;
    private final int myHashCode;

    public IdeVariantImpl(@NotNull Variant variant, @NotNull ModelCache modelCache, @NotNull IdeDependenciesFactory dependenciesFactory, @Nullable GradleVersion modelVersion) {
        super(variant, modelCache);
        this.myName = variant.getName();
        this.myDisplayName = variant.getDisplayName();
        this.myMainArtifact = modelCache.computeIfAbsent(variant.getMainArtifact(), artifact -> new IdeAndroidArtifactImpl((AndroidArtifact)artifact, modelCache, dependenciesFactory, modelVersion));
        this.myExtraAndroidArtifacts = IdeVariantImpl.copy(variant.getExtraAndroidArtifacts(), modelCache, (K artifact) -> new IdeAndroidArtifactImpl((AndroidArtifact)artifact, modelCache, dependenciesFactory, modelVersion));
        this.myExtraJavaArtifacts = IdeVariantImpl.copy(variant.getExtraJavaArtifacts(), modelCache, (K artifact) -> new IdeJavaArtifact((JavaArtifact)artifact, modelCache, dependenciesFactory, modelVersion));
        this.myBuildType = variant.getBuildType();
        this.myProductFlavors = ImmutableList.copyOf((Collection)variant.getProductFlavors());
        this.myMergedFlavor = modelCache.computeIfAbsent(variant.getMergedFlavor(), flavor -> new IdeProductFlavor((ProductFlavor)flavor, modelCache));
        this.myTestedTargetVariants = IdeVariantImpl.getTestedTargetVariants(variant, modelCache);
        this.myHashCode = this.calculateHashCode();
    }

    @NotNull
    private static Collection<TestedTargetVariant> getTestedTargetVariants(@NotNull Variant variant, @NotNull ModelCache modelCache) {
        try {
            return IdeVariantImpl.copy(variant.getTestedTargetVariants(), modelCache, (K targetVariant) -> new IdeTestedTargetVariant((TestedTargetVariant)targetVariant, modelCache));
        }
        catch (UnsupportedMethodException e) {
            return Collections.emptyList();
        }
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    @NotNull
    public IdeAndroidArtifact getMainArtifact() {
        return this.myMainArtifact;
    }

    @NotNull
    public Collection<AndroidArtifact> getExtraAndroidArtifacts() {
        return this.myExtraAndroidArtifacts;
    }

    @NotNull
    public Collection<JavaArtifact> getExtraJavaArtifacts() {
        return this.myExtraJavaArtifacts;
    }

    @NotNull
    public String getBuildType() {
        return this.myBuildType;
    }

    @NotNull
    public List<String> getProductFlavors() {
        return this.myProductFlavors;
    }

    @NotNull
    public ProductFlavor getMergedFlavor() {
        return this.myMergedFlavor;
    }

    @NotNull
    public Collection<TestedTargetVariant> getTestedTargetVariants() {
        return this.myTestedTargetVariants;
    }

    @Override
    @NotNull
    public Collection<IdeBaseArtifact> getTestArtifacts() {
        ImmutableSet.Builder testArtifacts = ImmutableSet.builder();
        Consumer action = artifact -> {
            if (artifact.isTestArtifact()) {
                testArtifacts.add(artifact);
            }
        };
        IdeVariantImpl.forEachArtifact(this.myExtraAndroidArtifacts, (Consumer<IdeBaseArtifact>)action);
        IdeVariantImpl.forEachArtifact(this.myExtraJavaArtifacts, (Consumer<IdeBaseArtifact>)action);
        return testArtifacts.build();
    }

    private static void forEachArtifact(@NotNull Collection<? extends BaseArtifact> artifacts, @NotNull Consumer<IdeBaseArtifact> action) {
        for (BaseArtifact baseArtifact : artifacts) {
            action.consume((Object)((IdeBaseArtifact)baseArtifact));
        }
    }

    @Override
    @Nullable
    public IdeAndroidArtifact getAndroidTestArtifact() {
        for (AndroidArtifact artifact : this.myExtraAndroidArtifacts) {
            IdeAndroidArtifactImpl ideArtifact = (IdeAndroidArtifactImpl)artifact;
            if (!ideArtifact.isTestArtifact()) continue;
            return ideArtifact;
        }
        return null;
    }

    @Override
    @Nullable
    public IdeJavaArtifact getUnitTestArtifact() {
        for (JavaArtifact artifact : this.myExtraJavaArtifacts) {
            IdeJavaArtifact ideArtifact = (IdeJavaArtifact)artifact;
            if (!ideArtifact.isTestArtifact()) continue;
            return ideArtifact;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeVariantImpl)) {
            return false;
        }
        IdeVariantImpl variant = (IdeVariantImpl)o;
        return Objects.equals(this.myName, variant.myName) && Objects.equals(this.myDisplayName, variant.myDisplayName) && Objects.equals(this.myMainArtifact, variant.myMainArtifact) && Objects.equals(this.myExtraAndroidArtifacts, variant.myExtraAndroidArtifacts) && Objects.equals(this.myExtraJavaArtifacts, variant.myExtraJavaArtifacts) && Objects.equals(this.myBuildType, variant.myBuildType) && Objects.equals(this.myProductFlavors, variant.myProductFlavors) && Objects.equals(this.myMergedFlavor, variant.myMergedFlavor) && Objects.equals(this.myTestedTargetVariants, variant.myTestedTargetVariants);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myDisplayName, this.myMainArtifact, this.myExtraAndroidArtifacts, this.myExtraJavaArtifacts, this.myBuildType, this.myProductFlavors, this.myMergedFlavor, this.myTestedTargetVariants);
    }

    public String toString() {
        return "IdeVariant{myName='" + this.myName + '\'' + ", myDisplayName='" + this.myDisplayName + '\'' + ", myMainArtifact=" + this.myMainArtifact + ", myExtraAndroidArtifacts=" + this.myExtraAndroidArtifacts + ", myExtraJavaArtifacts=" + this.myExtraJavaArtifacts + ", myBuildType='" + this.myBuildType + '\'' + ", myProductFlavors=" + this.myProductFlavors + ", myMergedFlavor=" + this.myMergedFlavor + ", myTestedTargetVariants=" + this.myTestedTargetVariants + "}";
    }
}

