/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.tools.idea.gradle.project.model.ide.android.IdeFilterData;
import com.android.tools.idea.gradle.project.model.ide.android.IdeModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeOutputFile;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeVariantOutput
extends IdeModel
implements VariantOutput {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final Collection<? extends OutputFile> myOutputs;
    @NotNull
    private final Collection<String> myFilterTypes;
    @Nullable
    private final Collection<FilterData> myFilters;
    @Nullable
    private final OutputFile myMainOutputFile;
    @Nullable
    private final String myOutputType;
    private final int myVersionCode;
    private final int myHashCode;

    public IdeVariantOutput(@NotNull VariantOutput output, @NotNull ModelCache modelCache) {
        super(output, modelCache);
        this.myOutputs = IdeVariantOutput.copy(output.getOutputs(), modelCache, (K outputFile) -> new IdeOutputFile((OutputFile)outputFile, modelCache));
        this.myFilterTypes = IdeVariantOutput.copyNewProperty(() -> ImmutableList.copyOf((Collection)output.getFilterTypes()), Collections.emptyList());
        this.myFilters = IdeVariantOutput.copyFilters(output, modelCache);
        this.myMainOutputFile = IdeVariantOutput.copyNewProperty(modelCache, () -> ((VariantOutput)output).getMainOutputFile(), file -> new IdeOutputFile((OutputFile)file, modelCache), null);
        this.myOutputType = IdeVariantOutput.copyNewProperty(() -> ((VariantOutput)output).getOutputType(), null);
        this.myVersionCode = output.getVersionCode();
        this.myHashCode = this.calculateHashCode();
    }

    @Nullable
    private static Collection<FilterData> copyFilters(@NotNull VariantOutput output, @NotNull ModelCache modelCache) {
        try {
            return IdeVariantOutput.copy(output.getFilters(), modelCache, (K data) -> new IdeFilterData((FilterData)data, modelCache));
        }
        catch (UnsupportedMethodException ignored) {
            return null;
        }
    }

    @NotNull
    public OutputFile getMainOutputFile() {
        if (this.myMainOutputFile != null) {
            return this.myMainOutputFile;
        }
        throw new UnsupportedMethodException("getMainOutputFile()");
    }

    @NotNull
    public Collection<? extends OutputFile> getOutputs() {
        return this.myOutputs;
    }

    @NotNull
    public String getOutputType() {
        if (this.myOutputType != null) {
            return this.myOutputType;
        }
        throw new UnsupportedMethodException("getOutputType");
    }

    @NotNull
    public Collection<String> getFilterTypes() {
        return this.myFilterTypes;
    }

    @NotNull
    public Collection<FilterData> getFilters() {
        if (this.myFilters != null) {
            return this.myFilters;
        }
        throw new UnsupportedMethodException("getFilters");
    }

    public int getVersionCode() {
        return this.myVersionCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeVariantOutput)) {
            return false;
        }
        IdeVariantOutput output = (IdeVariantOutput)o;
        return output.canEquals(this) && this.myVersionCode == output.myVersionCode && Objects.equals(this.myMainOutputFile, output.myMainOutputFile) && Objects.equals(this.myOutputs, output.myOutputs) && Objects.equals(this.myOutputType, output.myOutputType) && Objects.equals(this.myFilterTypes, output.myFilterTypes) && Objects.equals(this.myFilters, output.myFilters);
    }

    protected boolean canEquals(Object other) {
        return other instanceof IdeVariantOutput;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myMainOutputFile, this.myOutputs, this.myOutputType, this.myFilterTypes, this.myFilters, this.myVersionCode);
    }

    public String toString() {
        return "myMainOutputFile=" + this.myMainOutputFile + ", myOutputs=" + this.myOutputs + ", myOutputType='" + this.myOutputType + '\'' + ", myFilterTypes=" + this.myFilterTypes + ", myFilters=" + this.myFilters + ", myVersionCode=" + this.myVersionCode;
    }
}

