/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android.level2;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.builder.model.level2.GraphItem;
import com.android.builder.model.level2.Library;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeLibraries;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.level2.BuildFolderPaths;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependencies;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependenciesImpl;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeLibraryFactory;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeDependenciesFactory {
    @NotNull
    private final Map<String, Library> myLibrariesById = new HashMap<String, Library>();
    @NotNull
    private final IdeLibraryFactory myLibraryFactory = new IdeLibraryFactory();
    @NotNull
    private final BuildFolderPaths myBuildFolderPaths = new BuildFolderPaths();

    public void findAndAddBuildFolderPath(@NotNull GradleProject gradleProject) {
        this.myBuildFolderPaths.add(gradleProject);
    }

    public IdeDependencies create(@NotNull BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        ModelCache modelCache = new ModelCache();
        if (modelVersion != null && modelVersion.getMajor() >= 3 && NewGradleSync.isLevel4Model()) {
            return this.createFromDependencyGraphs(artifact.getDependencyGraphs());
        }
        return this.createFromDependencies(artifact.getDependencies(), modelCache);
    }

    @NotNull
    IdeDependencies createFromDependencyGraphs(@NotNull DependencyGraphs graphs) {
        return this.createInstance(graphs.getCompileDependencies().stream().map(GraphItem::getArtifactAddress).collect(Collectors.toList()));
    }

    @NotNull
    private IdeDependencies createFromDependencies(@NotNull Dependencies dependencies2, @NotNull ModelCache modelCache) {
        HashSet<String> visited = new HashSet<String>();
        this.populateAndroidLibraries(dependencies2.getLibraries(), visited, modelCache);
        this.populateJavaLibraries(dependencies2.getJavaLibraries(), visited, modelCache);
        for (String projectPath : dependencies2.getProjects()) {
            if (visited.contains(projectPath)) continue;
            visited.add(projectPath);
            this.myLibrariesById.computeIfAbsent(projectPath, id -> IdeLibraryFactory.create(projectPath, modelCache));
        }
        return this.createInstance(visited);
    }

    private void populateAndroidLibraries(@NotNull Collection<? extends AndroidLibrary> androidLibraries, @NotNull Set<String> visited, @NotNull ModelCache modelCache) {
        for (AndroidLibrary androidLibrary : androidLibraries) {
            String address = IdeLibraries.computeAddress((com.android.builder.model.Library)androidLibrary);
            if (visited.contains(address)) continue;
            visited.add(address);
            this.myLibrariesById.computeIfAbsent(address, id -> this.myLibraryFactory.create(androidLibrary, this.myBuildFolderPaths, modelCache));
            this.populateAndroidLibraries(androidLibrary.getLibraryDependencies(), visited, modelCache);
            this.populateJavaLibraries(IdeDependenciesFactory.getJavaDependencies(androidLibrary), visited, modelCache);
        }
    }

    @NotNull
    private static Collection<? extends JavaLibrary> getJavaDependencies(AndroidLibrary androidLibrary) {
        try {
            return androidLibrary.getJavaDependencies();
        }
        catch (UnsupportedMethodException e) {
            return Collections.emptyList();
        }
    }

    private void populateJavaLibraries(@NotNull Collection<? extends JavaLibrary> javaLibraries, @NotNull Set<String> visited, @NotNull ModelCache modelCache) {
        for (JavaLibrary javaLibrary : javaLibraries) {
            String address = IdeLibraries.computeAddress((com.android.builder.model.Library)javaLibrary);
            if (visited.contains(address)) continue;
            visited.add(address);
            this.myLibrariesById.computeIfAbsent(address, k -> this.myLibraryFactory.create(javaLibrary, modelCache));
            this.populateJavaLibraries(javaLibrary.getDependencies(), visited, modelCache);
        }
    }

    @NotNull
    private IdeDependencies createInstance(@NotNull Collection<String> artifactAddresses) {
        ImmutableList.Builder androidLibraries = ImmutableList.builder();
        ImmutableList.Builder javaLibraries = ImmutableList.builder();
        ImmutableList.Builder moduleDependencies = ImmutableList.builder();
        block5: for (String address : artifactAddresses) {
            Library library = this.myLibrariesById.get(address);
            assert (library != null);
            switch (library.getType()) {
                case 1: {
                    androidLibraries.add((Object)library);
                    continue block5;
                }
                case 2: {
                    javaLibraries.add((Object)library);
                    continue block5;
                }
                case 3: {
                    moduleDependencies.add((Object)library);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown library type " + library.getType());
        }
        return new IdeDependenciesImpl((ImmutableList<Library>)androidLibraries.build(), (ImmutableList<Library>)javaLibraries.build(), (ImmutableList<Library>)moduleDependencies.build());
    }

    public void setupGlobalLibraryMap(@NotNull GlobalLibraryMap globalLibraryMap) {
        ModelCache modelCache = new ModelCache();
        for (Library library : globalLibraryMap.getLibraries().values()) {
            this.myLibrariesById.computeIfAbsent(library.getArtifactAddress(), k -> this.myLibraryFactory.create(library, modelCache));
        }
    }
}

