/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.settings;

import com.android.tools.idea.gradle.project.settings.AndroidStudioGradleProjectSettings;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidStudioGradleProjectSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final AndroidStudioGradleProjectSettings mySettings;
    private JPanel myMainPanel;
    private JCheckBox myDisableEmbeddedRepoCheckbox;

    public AndroidStudioGradleProjectSettingsConfigurable(@NotNull Project project) {
        this.$$$setupUI$$$();
        this.mySettings = AndroidStudioGradleProjectSettings.getInstance(project);
        this.reset();
    }

    @NotNull
    public String getId() {
        return "android.studio.gradle";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.isEmbeddedRepoDisabled() != this.mySettings.DISABLE_EMBEDDED_MAVEN_REPO;
    }

    public void apply() {
        this.mySettings.DISABLE_EMBEDDED_MAVEN_REPO = this.isEmbeddedRepoDisabled();
    }

    @VisibleForTesting
    boolean isEmbeddedRepoDisabled() {
        return this.myDisableEmbeddedRepoCheckbox.isSelected();
    }

    void disableEmbeddedRepo() {
        this.myDisableEmbeddedRepoCheckbox.setSelected(true);
    }

    public void reset() {
        this.myDisableEmbeddedRepoCheckbox.setSelected(this.mySettings.DISABLE_EMBEDDED_MAVEN_REPO);
    }

    public String getDisplayName() {
        return "Android Studio";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDisableEmbeddedRepoCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Disable embedded Maven repository");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

