/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;

public class GradleFiles {
    private static final Key<Boolean> EXTERNAL_BUILD_FILES_MODIFIED = Key.create((String)"android.gradle.project.external.build.files.modified");
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileDocumentManager myDocumentManager;

    @NotNull
    public static GradleFiles getInstance(@NotNull Project project) {
        return (GradleFiles)ServiceManager.getService((Project)project, GradleFiles.class);
    }

    public GradleFiles(@NotNull Project project, @NotNull FileDocumentManager documentManager) {
        this.myProject = project;
        this.myDocumentManager = documentManager;
    }

    public boolean areGradleFilesModified(long referenceTimeInMillis) {
        File propertiesFilePath;
        if (referenceTimeInMillis <= 0L) {
            throw new IllegalArgumentException("Reference time (in milliseconds) should be greater than zero");
        }
        this.setExternalBuildFilesModified(false);
        if (this.areFilesInProjectRootFolderModified(referenceTimeInMillis, "gradle.properties", "settings.gradle")) {
            return true;
        }
        GradleWrapper gradleWrapper = GradleWrapper.find(this.myProject);
        if (gradleWrapper != null && (propertiesFilePath = gradleWrapper.getPropertiesFilePath()).exists()) {
            long modified = propertiesFilePath.lastModified();
            if (modified > referenceTimeInMillis) {
                return true;
            }
            VirtualFile propertiesFile = gradleWrapper.getPropertiesFile();
            if (propertiesFile != null && this.myDocumentManager.isFileModified(propertiesFile)) {
                return true;
            }
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            NdkModuleModel ndkModuleModel;
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
            if (buildFile != null) {
                if (this.myDocumentManager.isFileModified(buildFile)) {
                    return true;
                }
                File buildFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile);
                if (buildFilePath.lastModified() > referenceTimeInMillis) {
                    return true;
                }
            }
            if ((ndkModuleModel = NdkModuleModel.get(module)) == null) continue;
            for (File externalBuildFile : ndkModuleModel.getAndroidProject().getBuildFiles()) {
                if (externalBuildFile.lastModified() > referenceTimeInMillis) {
                    this.setExternalBuildFilesModified(true);
                    return true;
                }
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)externalBuildFile, (boolean)true);
                if (virtualFile == null || !this.myDocumentManager.isFileModified(virtualFile)) continue;
                this.setExternalBuildFilesModified(true);
                return true;
            }
        }
        return false;
    }

    private boolean areFilesInProjectRootFolderModified(long referenceTimeInMillis, String ... fileNames) {
        File rootFolderPath = Projects.getBaseDirPath(this.myProject);
        for (String fileName : fileNames) {
            File filePath = new File(rootFolderPath, fileName);
            if (!filePath.exists()) continue;
            long modified = filePath.lastModified();
            if (modified > referenceTimeInMillis) {
                return true;
            }
            VirtualFile rootFolder = this.myProject.getBaseDir();
            assert (rootFolder != null);
            VirtualFile virtualFile = rootFolder.findChild(fileName);
            if (virtualFile == null || !this.myDocumentManager.isFileModified(virtualFile)) continue;
            return true;
        }
        return false;
    }

    private void setExternalBuildFilesModified(boolean changed) {
        this.myProject.putUserData(EXTERNAL_BUILD_FILES_MODIFIED, (Object)(changed ? Boolean.valueOf(true) : null));
    }

    public boolean areExternalBuildFilesModified() {
        return (Boolean)EXTERNAL_BUILD_FILES_MODIFIED.get((UserDataHolder)this.myProject, (Object)false);
    }

    public boolean isGradleFile(@NotNull PsiFile psiFile) {
        VirtualFile file;
        if (psiFile.getFileType() == GroovyFileType.GROOVY_FILE_TYPE && (file = psiFile.getVirtualFile()) != null && "gradle".equals(file.getExtension())) {
            return true;
        }
        return psiFile.getFileType() == PropertiesFileType.INSTANCE && (file = psiFile.getVirtualFile()) != null && ("gradle.properties".equals(file.getName()) || "gradle-wrapper.properties".equals(file.getName()));
    }
}

