/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class GradleSyncFailureHandler {
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final IdeSdks myIdeSdks;

    @NotNull
    public static GradleSyncFailureHandler getInstance() {
        return (GradleSyncFailureHandler)ServiceManager.getService(GradleSyncFailureHandler.class);
    }

    public GradleSyncFailureHandler(@NotNull IdeInfo ideInfo, @NotNull IdeSdks ideSdks) {
        this.myIdeInfo = ideInfo;
        this.myIdeSdks = ideSdks;
    }

    public void createTopLevelModelAndOpenProject(@NotNull Project project) {
        ApplicationManager.getApplication().runWriteAction(() -> this.createTopLevelModule(project));
        Projects.open(project);
        ToolWindows.activateProjectView(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void createTopLevelModule(@NotNull Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        File projectRootDir = Projects.getBaseDirPath(project);
        VirtualFile contentRoot = VfsUtil.findFileByIoFile((File)projectRootDir, (boolean)true);
        if (contentRoot != null) {
            Sdk jdk;
            File moduleFile = new File(projectRootDir, projectRootDir.getName() + ".iml");
            Module module = moduleManager.newModule(moduleFile.getPath(), StdModuleTypes.JAVA.getId());
            module.setOption("external.system.id", GradleUtil.GRADLE_SYSTEM_ID.getId());
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            model.addContentEntry(contentRoot);
            if (this.myIdeInfo.isAndroidStudio() && (jdk = this.myIdeSdks.getJdk()) != null) {
                model.setSdk(jdk);
            }
            model.commit();
            FacetManager facetManager = FacetManager.getInstance((Module)module);
            ModifiableFacetModel facetModel = facetManager.createModifiableModel();
            try {
                GradleFacet gradleFacet = GradleFacet.getInstance(module);
                if (gradleFacet == null) {
                    gradleFacet = (GradleFacet)facetManager.createFacet((FacetType)GradleFacet.getFacetType(), GradleFacet.getFacetName(), null);
                    facetModel.addFacet((Facet)gradleFacet);
                }
                ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH = ":";
            }
            finally {
                facetModel.commit();
            }
        }
    }
}

