/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncFailureHandler;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.cleanup.PreSyncProjectCleanUp;
import com.android.tools.idea.gradle.project.sync.idea.IdeaGradleSync;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncChecks;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.AppUIUtil;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSyncInvoker {
    @NotNull
    private final FileDocumentManager myFileDocumentManager;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final GradleSyncFailureHandler mySyncFailureHandler;
    @NotNull
    private final PreSyncProjectCleanUp myPreSyncProjectCleanUp;
    @NotNull
    private final PreSyncChecks myPreSyncChecks;

    @NotNull
    public static GradleSyncInvoker getInstance() {
        return (GradleSyncInvoker)ServiceManager.getService(GradleSyncInvoker.class);
    }

    public GradleSyncInvoker(@NotNull FileDocumentManager fileDocumentManager, @NotNull IdeInfo ideInfo, @NotNull GradleSyncFailureHandler syncFailureHandler) {
        this(fileDocumentManager, ideInfo, syncFailureHandler, new PreSyncProjectCleanUp(), new PreSyncChecks());
    }

    @VisibleForTesting
    GradleSyncInvoker(@NotNull FileDocumentManager fileDocumentManager, @NotNull IdeInfo ideInfo, @NotNull GradleSyncFailureHandler syncFailureHandler, @NotNull PreSyncProjectCleanUp preSyncProjectCleanUp, @NotNull PreSyncChecks preSyncChecks) {
        this.myFileDocumentManager = fileDocumentManager;
        this.myIdeInfo = ideInfo;
        this.mySyncFailureHandler = syncFailureHandler;
        this.myPreSyncProjectCleanUp = preSyncProjectCleanUp;
        this.myPreSyncChecks = preSyncChecks;
    }

    public void requestProjectSyncAndSourceGeneration(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger, @Nullable GradleSyncListener listener) {
        this.requestProjectSync(project, new Request().setTrigger(trigger), listener);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener) {
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        if (GradleSyncInvoker.isBuildInProgress(project)) {
            Projects.setSyncRequestedDuringBuild(project, true);
            return;
        }
        Runnable syncTask = () -> {
            ExternalSystemUtil.ensureToolWindowContentInitialized((Project)project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
            try {
                if (this.prepareProject(project, request, listener)) {
                    if (StudioFlags.GRADLE_INVOCATIONS_INDEXING_AWARE.get().booleanValue()) {
                        DumbService.getInstance((Project)project).runWhenSmart(() -> this.sync(project, request, listener));
                    } else {
                        this.sync(project, request, listener);
                    }
                }
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)e.getTitle());
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.invokeAndWait(syncTask);
            return;
        }
        if (request.isRunInBackground()) {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)project, syncTask);
        } else {
            TransactionGuard.getInstance().submitTransactionAndWait(syncTask);
        }
    }

    private static boolean isBuildInProgress(@NotNull Project project) {
        StatusBarEx statusBar;
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(project);
        StatusBarEx statusBarEx = statusBar = frame == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            return false;
        }
        for (Pair backgroundProcess : statusBar.getBackgroundProcesses()) {
            ProgressIndicator second;
            TaskInfo task = (TaskInfo)backgroundProcess.getFirst();
            if (!(task instanceof GradleTasksExecutor) || !(second = (ProgressIndicator)backgroundProcess.getSecond()).isRunning()) continue;
            return true;
        }
        return false;
    }

    private boolean prepareProject(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener) throws ConfigurationException {
        if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() || GradleSyncInvoker.hasTopLevelGradleBuildFile(project)) {
            if (!request.isNewOrImportedProject()) {
                this.myFileDocumentManager.saveAllDocuments();
            }
            return true;
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> {
            String msg = String.format("The project '%s' is not a Gradle-based project", project.getName());
            AndroidNotification.getInstance(project).showBalloon("Project Sync", msg, NotificationType.ERROR, new OpenMigrationToGradleUrlHyperlink());
            if (listener != null) {
                listener.syncFailed(project, msg);
            }
        });
        return false;
    }

    private static boolean hasTopLevelGradleBuildFile(@NotNull Project project) {
        String projectFolderPath = project.getBasePath();
        if (projectFolderPath != null) {
            File buildFile = new File(projectFolderPath, "build.gradle");
            return buildFile.isFile();
        }
        return false;
    }

    private void sync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener) {
        PreSyncCheckResult canSync;
        if (this.myIdeInfo.isAndroidStudio()) {
            GradleUtil.clearStoredGradleJvmArgs(project);
        }
        if (!(canSync = this.myPreSyncChecks.canSync(project)).isSuccess()) {
            String cause = Strings.nullToEmpty((String)canSync.getFailureCause());
            this.handlePreSyncCheckFailure(project, cause, listener, request.getTrigger());
            return;
        }
        boolean started = request.isUseCachedGradleModels() ? GradleSyncState.getInstance(project).skippedSyncStarted(!request.isNewOrImportedProject(), request.getTrigger()) : GradleSyncState.getInstance(project).syncStarted(!request.isNewOrImportedProject(), request.getTrigger());
        if (!started) {
            return;
        }
        boolean useNewGradleSync = NewGradleSync.isEnabled();
        if (!useNewGradleSync) {
            GradleSyncInvoker.removeAndroidModels(project);
        }
        this.myPreSyncProjectCleanUp.cleanUp(project);
        GradleSync gradleSync = useNewGradleSync ? new NewGradleSync(project) : new IdeaGradleSync(project);
        gradleSync.sync(request, listener);
    }

    private void handlePreSyncCheckFailure(@NotNull Project project, @NotNull String failureCause, @Nullable GradleSyncListener syncListener, @NotNull GradleSyncStats.Trigger trigger) {
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        if (syncState.syncStarted(true, trigger)) {
            this.mySyncFailureHandler.createTopLevelModelAndOpenProject(project);
            syncState.syncFailed(failureCause);
            if (syncListener != null) {
                syncListener.syncFailed(project, failureCause);
            }
        }
    }

    private static void removeAndroidModels(@NotNull Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            facet.setAndroidModel(null);
        }
    }

    public static class Request {
        private boolean myRunInBackground = true;
        private boolean myGenerateSourcesOnSuccess = true;
        private boolean myCleanProject;
        private boolean myUseCachedGradleModels;
        private boolean myNewOrImportedProject;
        private boolean mySkipAndroidPluginUpgrade;
        private GradleSyncStats.Trigger myTrigger = GradleSyncStats.Trigger.TRIGGER_UNKNOWN;

        public boolean isRunInBackground() {
            return this.myRunInBackground;
        }

        @NotNull
        public Request setRunInBackground(boolean runInBackground) {
            this.myRunInBackground = runInBackground;
            return this;
        }

        public boolean isGenerateSourcesOnSuccess() {
            return this.myGenerateSourcesOnSuccess;
        }

        @NotNull
        public Request setGenerateSourcesOnSuccess(boolean generateSourcesOnSuccess) {
            this.myGenerateSourcesOnSuccess = generateSourcesOnSuccess;
            return this;
        }

        public boolean isCleanProject() {
            return this.myCleanProject;
        }

        @NotNull
        public Request setCleanProject() {
            this.myCleanProject = true;
            return this;
        }

        public boolean isUseCachedGradleModels() {
            return this.myUseCachedGradleModels;
        }

        @NotNull
        public Request setUseCachedGradleModels(boolean useCachedGradleModels) {
            this.myUseCachedGradleModels = useCachedGradleModels;
            return this;
        }

        public boolean isNewOrImportedProject() {
            return this.myNewOrImportedProject;
        }

        @NotNull
        public Request setNewOrImportedProject() {
            this.myNewOrImportedProject = true;
            return this;
        }

        public boolean isSkipAndroidPluginUpgrade() {
            return this.mySkipAndroidPluginUpgrade;
        }

        public void setSkipAndroidPluginUpgrade() {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            this.mySkipAndroidPluginUpgrade = true;
        }

        @NotNull
        public GradleSyncStats.Trigger getTrigger() {
            return this.myTrigger;
        }

        @NotNull
        public Request setTrigger(GradleSyncStats.Trigger trigger) {
            this.myTrigger = trigger;
            return this;
        }

        @NotNull
        public ProgressExecutionMode getProgressExecutionMode() {
            return this.isRunInBackground() ? ProgressExecutionMode.IN_BACKGROUND_ASYNC : ProgressExecutionMode.MODAL_SYNC;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.myRunInBackground == request.myRunInBackground && this.myCleanProject == request.myCleanProject && this.myGenerateSourcesOnSuccess == request.myGenerateSourcesOnSuccess && this.myUseCachedGradleModels == request.myUseCachedGradleModels && this.myNewOrImportedProject == request.myNewOrImportedProject && this.myTrigger == request.myTrigger;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myRunInBackground, this.myCleanProject, this.myGenerateSourcesOnSuccess, this.myUseCachedGradleModels, this.myNewOrImportedProject, this.myTrigger});
        }

        public String toString() {
            return "RequestSettings{myRunInBackground=" + this.myRunInBackground + ", myCleanProject=" + this.myCleanProject + ", myGenerateSourcesOnSuccess=" + this.myGenerateSourcesOnSuccess + ", myUseCachedGradleModels=" + this.myUseCachedGradleModels + ", myNewOrImportedProject=" + this.myNewOrImportedProject + ", myTrigger=" + this.myTrigger + '}';
        }
    }
}

