/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.cleanup;

import com.android.tools.idea.gradle.project.sync.cleanup.ProjectCleanUpTask;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

class GradleSettingsCleanUpTask
extends ProjectCleanUpTask {
    GradleSettingsCleanUpTask() {
    }

    @Override
    void cleanUp(@NotNull Project project) {
        GradleProjectSettings projectSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
        if (projectSettings == null) {
            projectSettings = new GradleProjectSettings();
        }
        GradleSettingsCleanUpTask.setUpGradleProjectSettings(project, projectSettings);
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)project);
        gradleSettings.setLinkedProjectsSettings((Collection)ImmutableList.of((Object)projectSettings));
    }

    private static void setUpGradleProjectSettings(@NotNull Project project, @NotNull GradleProjectSettings settings) {
        String basePath;
        Sdk jdk;
        settings.setUseAutoImport(false);
        if (ApplicationManager.getApplication().isUnitTestMode() && (jdk = IdeSdks.getInstance().getJdk()) != null) {
            settings.setGradleJvm(jdk.getName());
        }
        if ((basePath = project.getBasePath()) != null) {
            settings.setExternalProjectPath(basePath);
        }
    }
}

