/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.cleanup;

import com.android.tools.idea.gradle.project.ProxySettingsDialog;
import com.android.tools.idea.gradle.project.sync.cleanup.AndroidStudioCleanUpTask;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.ProxySettings;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

class HttpProxySettingsCleanUpTask
extends AndroidStudioCleanUpTask {
    HttpProxySettingsCleanUpTask() {
    }

    @Override
    void doCleanUp(@NotNull Project project) {
        ProxySettingsDialog dialog;
        GradleProperties properties;
        HttpConfigurable ideHttpProxySettings = HttpConfigurable.getInstance();
        if (!ideHttpProxySettings.USE_HTTP_PROXY || StringUtil.isEmpty((String)ideHttpProxySettings.PROXY_HOST)) {
            return;
        }
        try {
            properties = new GradleProperties(project);
        }
        catch (IOException e) {
            this.getLogger().info("Failed to read gradle.properties file", (Throwable)e);
            return;
        }
        ProxySettings gradleProxySettings = properties.getHttpProxySettings();
        ProxySettings ideProxySettings = new ProxySettings(ideHttpProxySettings);
        if (!ideProxySettings.equals(gradleProxySettings) && (dialog = new ProxySettingsDialog(project, ideProxySettings)).showAndGet()) {
            dialog.applyProxySettings(properties.getProperties());
            try {
                properties.save();
            }
            catch (IOException e) {
                Throwable root = ExceptionUtil.getRootCause((Throwable)e);
                String cause = root.getMessage();
                String errMsg = "Failed to save HTTP proxy settings to gradle.properties file.";
                if (StringUtil.isNotEmpty((String)cause)) {
                    if (!cause.endsWith(".")) {
                        cause = cause + ".";
                    }
                    errMsg = errMsg + String.format("\nCause: %1$s", cause);
                }
                AndroidNotification notification = AndroidNotification.getInstance(project);
                notification.showBalloon("Proxy Settings", errMsg, NotificationType.ERROR);
                this.getLogger().info("Failed to save changes to gradle.properties file", root);
            }
        }
    }

    @NotNull
    private Logger getLogger() {
        return Logger.getInstance(this.getClass());
    }
}

