/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.common;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.actions.RefreshLinkedCppProjectsAction;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.project.sync.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineArgs {
    @NotNull
    private final ApplicationInfo myApplicationInfo;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final GradleInitScripts myInitScripts;
    private final boolean myApplyJavaLibraryPlugin;

    public CommandLineArgs(boolean applyJavaLibraryPlugin) {
        this(ApplicationInfo.getInstance(), IdeInfo.getInstance(), GradleInitScripts.getInstance(), applyJavaLibraryPlugin);
    }

    @VisibleForTesting
    CommandLineArgs(@NotNull ApplicationInfo applicationInfo, @NotNull IdeInfo ideInfo, @NotNull GradleInitScripts initScripts, boolean applyJavaLibraryPlugin) {
        this.myApplicationInfo = applicationInfo;
        this.myIdeInfo = ideInfo;
        this.myInitScripts = initScripts;
        this.myApplyJavaLibraryPlugin = applyJavaLibraryPlugin;
    }

    @NotNull
    public List<String> get(@Nullable Project project) {
        Boolean refreshExternalNativeModels;
        String[] extraOptions;
        ArrayList<String> args = new ArrayList<String>();
        if (this.myApplyJavaLibraryPlugin) {
            this.myInitScripts.addApplyJavaLibraryPluginInitScriptCommandLineArg(args);
        }
        args.add("-Djava.awt.headless=true");
        if (project != null && (extraOptions = (String[])project.getUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY)) != null) {
            project.putUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY, null);
            Collections.addAll(args, extraOptions);
        }
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.advanced", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.versioned", (int)(NewGradleSync.isLevel4Model() ? 4 : 3)));
        if (this.myIdeInfo.isAndroidStudio()) {
            args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.studio.version", (String)this.myApplicationInfo.getStrictVersion()));
        }
        if (project != null && (refreshExternalNativeModels = (Boolean)project.getUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY)) != null) {
            project.putUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, null);
            args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.refresh.external.native.model", (boolean)refreshExternalNativeModels));
        }
        Application application = ApplicationManager.getApplication();
        if (AndroidPlugin.isGuiTestingMode() || application.isUnitTestMode()) {
            application.putUserData(AndroidPlugin.GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY, (Object)ArrayUtil.toStringArray(args));
        }
        if (project == null || GradleProjectInfo.getInstance(project).canUseLocalMavenRepo()) {
            this.myInitScripts.addLocalMavenRepoInitScriptCommandLineArg(args);
        }
        return args;
    }
}

