/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.common;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.google.common.collect.Lists;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantSelector {
    @Nullable
    public Variant findVariantToSelect(@NotNull AndroidProject androidProject) {
        Collection variants = androidProject.getVariants();
        if (variants.size() == 1) {
            Variant variant = (Variant)ContainerUtil.getFirstItem((Collection)variants);
            assert (variant != null);
            return variant;
        }
        for (Variant variant : variants) {
            if (!"debug".equals(variant.getName())) continue;
            return variant;
        }
        ArrayList sortedVariants = Lists.newArrayList((Iterable)variants);
        Collections.sort(sortedVariants, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return sortedVariants.isEmpty() ? null : (Variant)sortedVariants.get(0);
    }
}

