/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityCheck;
import com.android.tools.idea.gradle.project.sync.compatibility.Component;
import com.android.tools.idea.gradle.project.sync.compatibility.version.BuildFileComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.project.messages.MessageType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.intellij.lang.annotations.Language;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CompatibilityChecksMetadata {
    @NonNls
    private static final String BUILD_FILE_PREFIX = "buildFile:";
    @NonNls
    private static final String METADATA_FILE_NAME = "android-component-compatibility.xml";
    private final int myDataVersion;
    @NotNull
    private final List<CompatibilityCheck> myCompatibilityChecks = new ArrayList<CompatibilityCheck>();
    @NotNull
    private final Map<String, ComponentVersionReader> myReadersByComponentName = new ConcurrentHashMap<String, ComponentVersionReader>();

    @NotNull
    static CompatibilityChecksMetadata reload() {
        File metadataFilePath = CompatibilityChecksMetadata.getSourceFilePath();
        if (metadataFilePath.isFile()) {
            try {
                Element root = JDOMUtil.load((File)metadataFilePath);
                return CompatibilityChecksMetadata.load(root);
            }
            catch (Throwable e) {
                String message = "Failed to load/parse file '" + metadataFilePath.getPath() + "'. Loading metadata from local file.";
                CompatibilityChecksMetadata.getLogger().info(message, e);
                return CompatibilityChecksMetadata.loadLocal();
            }
        }
        return CompatibilityChecksMetadata.loadLocal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static CompatibilityChecksMetadata loadLocal() {
        try (InputStream inputStream = CompatibilityChecksMetadata.class.getResourceAsStream(METADATA_FILE_NAME);){
            Element root = JDOMUtil.load((InputStream)inputStream);
            CompatibilityChecksMetadata compatibilityChecksMetadata = CompatibilityChecksMetadata.load(root);
            return compatibilityChecksMetadata;
        }
        catch (RuntimeException e) {
            CompatibilityChecksMetadata.logFailureToReadLocalFile(e);
            throw e;
        }
        catch (Throwable e) {
            CompatibilityChecksMetadata.logFailureToReadLocalFile(e);
            throw new RuntimeException(e);
        }
    }

    private static void logFailureToReadLocalFile(@NotNull Throwable e) {
        CompatibilityChecksMetadata.getLogger().info("Failed to load/parse local metadata file.", e);
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(CompatibilityChecksMetadata.class);
    }

    @VisibleForTesting
    @NotNull
    static CompatibilityChecksMetadata reloadForTesting(@NotNull @Language(value="XML") String metadata) throws JDOMException, IOException {
        Element root = JDOMUtil.load((Reader)new StringReader(metadata));
        return CompatibilityChecksMetadata.load(root);
    }

    @NotNull
    static File getSourceFilePath() {
        File configPath = FilePaths.toSystemDependentPath(PathManager.getConfigPath());
        return new File(configPath, METADATA_FILE_NAME);
    }

    @NotNull
    static CompatibilityChecksMetadata load(@NotNull Element root) {
        String dataVersionText = root.getAttributeValue("version");
        int dataVersion = 1;
        try {
            dataVersion = Integer.parseInt(dataVersionText);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        CompatibilityChecksMetadata metadata = new CompatibilityChecksMetadata(dataVersion);
        for (Element checkElement : root.getChildren("check")) {
            Element componentElement = checkElement.getChild("component");
            Component version = CompatibilityChecksMetadata.createComponent(componentElement, metadata);
            for (Element requirementElement : componentElement.getChildren("requires")) {
                version.addRequirement(CompatibilityChecksMetadata.createComponent(requirementElement, metadata));
            }
            String type = checkElement.getAttributeValue("failureType");
            CompatibilityCheck check = new CompatibilityCheck(version, CompatibilityChecksMetadata.getFailureType(type));
            metadata.myCompatibilityChecks.add(check);
        }
        return metadata;
    }

    @NotNull
    private static MessageType getFailureType(@NotNull String value) {
        MessageType type = MessageType.findByName(value);
        return type != null ? type : MessageType.ERROR;
    }

    @NotNull
    private static Component createComponent(@NotNull Element xmlElement, @NotNull CompatibilityChecksMetadata metadata) {
        String name = xmlElement.getAttribute("name").getValue();
        if (name.startsWith(BUILD_FILE_PREFIX)) {
            name = name.substring(BUILD_FILE_PREFIX.length());
            metadata.addIfAbsent(name, new BuildFileComponentVersionReader(name));
        }
        String version = xmlElement.getAttributeValue("version");
        String failureMsg = null;
        Element failureMsgElement = xmlElement.getChild("failureMsg");
        if (failureMsgElement != null) {
            failureMsg = Strings.emptyToNull((String)failureMsgElement.getTextNormalize());
        }
        return new Component(name, version, failureMsg);
    }

    CompatibilityChecksMetadata(int dataVersion) {
        this.myDataVersion = dataVersion;
        this.myReadersByComponentName.put("gradle", ComponentVersionReader.GRADLE);
        this.myReadersByComponentName.put("android-gradle-plugin", ComponentVersionReader.ANDROID_GRADLE_PLUGIN);
        this.myReadersByComponentName.put("android-gradle-experimental-plugin", ComponentVersionReader.ANDROID_GRADLE_EXPERIMENTAL_PLUGIN);
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.myReadersByComponentName.put("android-studio", ComponentVersionReader.ANDROID_STUDIO);
        }
    }

    private void addIfAbsent(@NotNull String name, @NotNull ComponentVersionReader componentVersionReader) {
        this.myReadersByComponentName.putIfAbsent(name, componentVersionReader);
    }

    int getDataVersion() {
        return this.myDataVersion;
    }

    ComponentVersionReader findComponentVersionReader(@NotNull String name) {
        return this.myReadersByComponentName.get(name);
    }

    @NotNull
    List<CompatibilityCheck> getCompatibilityChecks() {
        return ImmutableList.copyOf(this.myCompatibilityChecks);
    }

    @NotNull
    Map<String, ComponentVersionReader> getReadersByComponentName() {
        return this.myReadersByComponentName;
    }
}

