/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityCheck;
import com.android.tools.idea.gradle.project.sync.compatibility.Component;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.compatibility.version.VersionRange;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class VersionIncompatibility {
    @NotNull
    private final Module myModule;
    @NotNull
    private final CompatibilityCheck myCompatibilityCheck;
    @NotNull
    private final Pair<ComponentVersionReader, String> myReaderAndVersion;
    @NotNull
    private final Component myRequirement;
    @NotNull
    private final ComponentVersionReader myRequirementVersionReader;
    @NotNull
    private final List<String> myMessages = new ArrayList<String>();

    VersionIncompatibility(@NotNull Module module, @NotNull CompatibilityCheck compatibilityCheck, @NotNull Pair<ComponentVersionReader, String> readerAndVersion, @NotNull Component requirement, @NotNull ComponentVersionReader requirementVersionReader) {
        this.myModule = module;
        this.myCompatibilityCheck = compatibilityCheck;
        this.myReaderAndVersion = readerAndVersion;
        this.myRequirement = requirement;
        this.myRequirementVersionReader = requirementVersionReader;
    }

    boolean hasMessages() {
        return !this.myMessages.isEmpty();
    }

    void addMessage(@NotNull String message) {
        this.myMessages.add(message);
    }

    /*
     * WARNING - void declaration
     */
    void reportMessages(@NotNull Project project) {
        void var11_14;
        ComponentVersionReader reader = (ComponentVersionReader)this.myReaderAndVersion.getFirst();
        String componentName = reader.getComponentName();
        String version = (String)this.myReaderAndVersion.getSecond();
        String requirementComponentName = this.myRequirementVersionReader.getComponentName();
        StringBuilder msg = new StringBuilder();
        msg.append(componentName).append(" ").append(version);
        PositionInFile position = reader.getVersionSource(this.myModule);
        if (!reader.isProjectLevel() && position == null) {
            msg.append(", in module '").append(this.myModule.getName()).append(",'");
        }
        msg.append(" requires ").append(requirementComponentName).append(" ");
        VersionRange requirementVersionRange = this.myRequirement.getVersionRange();
        msg.append(requirementVersionRange.getDescription());
        int messageCount = this.myMessages.size();
        if (messageCount == 1) {
            msg.append(" ").append(this.myMessages.get(0));
        } else if (messageCount > 1) {
            msg.append("<ul>");
            for (String string : this.myMessages) {
                msg.append("<li>").append(string).append("</li>");
            }
            msg.append("</ul>");
        }
        MessageType messageType = this.myCompatibilityCheck.getType();
        ArrayList<String> textLines = new ArrayList<String>();
        textLines.add(msg.toString());
        String failureMsg = this.myRequirement.getFailureMessage();
        if (failureMsg != null) {
            List lines = Splitter.on((String)"\\n").omitEmptyStrings().splitToList((CharSequence)failureMsg);
            textLines.addAll(lines);
        }
        String[] text = ArrayUtil.toStringArray(textLines);
        if (position != null) {
            SyncMessage syncMessage = new SyncMessage(project, "Version Compatibility Issues", messageType, position, text);
        } else {
            SyncMessage syncMessage = new SyncMessage("Version Compatibility Issues", messageType, text);
        }
        var11_14.add(this.myRequirementVersionReader.getQuickFixes(this.myModule, requirementVersionRange, position));
        GradleSyncMessages.getInstance(project).report((SyncMessage)var11_14);
    }

    @NotNull
    MessageType getType() {
        return this.myCompatibilityCheck.getType();
    }
}

