/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility.version;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.compatibility.version.VersionRange;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidGradlePluginVersionReader
implements ComponentVersionReader {
    @NotNull
    private final AndroidPluginGeneration myPluginGeneration;

    AndroidGradlePluginVersionReader(@NotNull AndroidPluginGeneration pluginGeneration) {
        this.myPluginGeneration = pluginGeneration;
    }

    @Override
    public boolean appliesTo(@NotNull Module module) {
        if (AndroidFacet.getInstance(module) == null) {
            return false;
        }
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(module.getProject());
        return this.isSupportedGeneration(pluginInfo);
    }

    @Override
    @Nullable
    public String getComponentVersion(@NotNull Module module) {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(module.getProject());
        if (this.isSupportedGeneration(pluginInfo)) {
            GradleVersion pluginVersion = pluginInfo.getPluginVersion();
            return pluginVersion != null ? pluginVersion.toString() : null;
        }
        return null;
    }

    @Override
    @Nullable
    public PositionInFile getVersionSource(@NotNull Module module) {
        return null;
    }

    @Override
    @NotNull
    public List<NotificationHyperlink> getQuickFixes(@NotNull Module module, @Nullable VersionRange expectedVersion, @Nullable PositionInFile location) {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(module.getProject());
        if (this.isSupportedGeneration(pluginInfo)) {
            String version = pluginInfo.getPluginGeneration().getLatestKnownVersion();
            ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
            quickFixes.add(new FixAndroidGradlePluginVersionHyperlink(GradleVersion.parse((String)version), GradleVersion.parse((String)"4.1")));
            quickFixes.add(new OpenUrlHyperlink("https://developer.android.com/studio/releases/gradle-plugin.html#updating-gradle", "Open Documentation"));
            return quickFixes;
        }
        return Collections.emptyList();
    }

    private boolean isSupportedGeneration(@Nullable AndroidPluginInfo pluginInfo) {
        return pluginInfo != null && this.myPluginGeneration == pluginInfo.getPluginGeneration();
    }

    @Override
    public boolean isProjectLevel() {
        return true;
    }

    @Override
    @NotNull
    public String getComponentName() {
        return this.myPluginGeneration.getDescription();
    }
}

